/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.SystemInfo;
import java.awt.datatransfer.DataFlavor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClipboardUtil {
    private static final Logger LOG = Logger.getInstance(ClipboardUtil.class);

    public static <E> E handleClipboardSafely(@NotNull Supplier<? extends E> supplier2, E defaultValue) {
        try {
            return supplier2.get();
        }
        catch (IllegalStateException e) {
            if (SystemInfo.isWindows) {
                LOG.debug("Clipboard is busy");
            } else {
                LOG.warn((Throwable)e);
            }
        }
        catch (NullPointerException e) {
            LOG.warn("Java bug #6322854", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Java bug #7173464", (Throwable)e);
        }
        return defaultValue;
    }

    @Nullable
    public static String getTextInClipboard() {
        return (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
    }
}

