/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PresentationFactory {
    private final Map<AnAction, Presentation> myAction2Presentation = ContainerUtil.createWeakMap();
    private static final WeakList<PresentationFactory> ourAllFactories = new WeakList();

    public PresentationFactory() {
        ourAllFactories.add((Object)this);
    }

    @NotNull
    public final Presentation getPresentation(@NotNull AnAction action2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Presentation presentation2 = this.myAction2Presentation.get(action2);
        if (presentation2 == null || !action2.isDefaultIcon()) {
            Presentation templatePresentation = action2.getTemplatePresentation();
            if (presentation2 == null) {
                presentation2 = templatePresentation.clone();
                this.myAction2Presentation.put(action2, presentation2);
            }
            if (!action2.isDefaultIcon()) {
                presentation2.setIcon(templatePresentation.getIcon());
                presentation2.setDisabledIcon(templatePresentation.getDisabledIcon());
            }
            this.processPresentation(presentation2);
        }
        return presentation2;
    }

    protected void processPresentation(Presentation presentation2) {
    }

    public void reset() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myAction2Presentation.clear();
    }

    public static void clearPresentationCaches() {
        for (PresentationFactory factory2 : ourAllFactories) {
            factory2.reset();
        }
    }
}

