/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AbbreviationManager", storages={@Storage(value="abbreviations.xml", roamingType=RoamingType.PER_OS)})
public class AbbreviationManagerImpl
extends AbbreviationManager
implements PersistentStateComponent<Element> {
    private final Map<String, List<String>> myAbbreviation2ActionId = new THashMap();
    private final Map<String, Set<String>> myActionId2Abbreviations = new THashMap();
    private final Map<String, Set<String>> myPluginsActionId2Abbreviations = new THashMap();

    @Nullable
    public Element getState() {
        Element actions = new Element("actions");
        if (this.myActionId2Abbreviations.isEmpty()) {
            return actions;
        }
        Element abbreviations = null;
        for (Map.Entry<String, Set<String>> entry : this.myActionId2Abbreviations.entrySet()) {
            Set<String> pluginAbbrs;
            String key = entry.getKey();
            Set<String> abbrs = entry.getValue();
            if (abbrs == (pluginAbbrs = this.myPluginsActionId2Abbreviations.get(key)) || abbrs != null && abbrs.equals(pluginAbbrs) || abbrs == null) continue;
            if (abbreviations == null) {
                abbreviations = new Element("abbreviations");
                actions.addContent(abbreviations);
            }
            Element action2 = new Element("action");
            action2.setAttribute("id", key);
            abbreviations.addContent(action2);
            for (String abbr : abbrs) {
                Element abbreviation = new Element("abbreviation");
                abbreviation.setAttribute("name", abbr);
                action2.addContent(abbreviation);
            }
        }
        return actions;
    }

    public void loadState(@NotNull Element state) {
        List abbreviations = state.getChildren("abbreviations");
        if (abbreviations.size() == 1) {
            List actions = ((Element)abbreviations.get(0)).getChildren("action");
            for (Element action2 : actions) {
                String actionId = action2.getAttributeValue("id");
                Set values2 = this.myActionId2Abbreviations.computeIfAbsent(actionId, k -> new LinkedHashSet(1));
                for (Element abbr : action2.getChildren("abbreviation")) {
                    String abbrValue = abbr.getAttributeValue("name");
                    if (abbrValue == null) continue;
                    values2.add(abbrValue);
                    this.myAbbreviation2ActionId.computeIfAbsent(abbrValue, k -> new ArrayList()).add(actionId);
                }
            }
        }
    }

    @NotNull
    public Set<String> getAbbreviations() {
        return this.myActionId2Abbreviations.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @NotNull
    public Set<String> getAbbreviations(@NotNull String actionId) {
        Set<String> abbreviations = this.myActionId2Abbreviations.get(actionId);
        if (abbreviations == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(abbreviations);
    }

    @NotNull
    public List<String> findActions(@NotNull String abbreviation) {
        List<String> actions = this.myAbbreviation2ActionId.get(abbreviation);
        return actions == null ? Collections.emptyList() : Collections.unmodifiableList(actions);
    }

    private static void register(@NotNull String abbreviation, @NotNull String actionId, @NotNull Map<String, Set<String>> storage) {
        storage.computeIfAbsent(actionId, k -> new LinkedHashSet(1)).add(abbreviation);
    }

    public void register(@NotNull String abbreviation, @NotNull String actionId, boolean fromPluginXml) {
        List ids;
        if (fromPluginXml && this.myActionId2Abbreviations.containsKey(actionId)) {
            AbbreviationManagerImpl.register(abbreviation, actionId, this.myPluginsActionId2Abbreviations);
            return;
        }
        AbbreviationManagerImpl.register(abbreviation, actionId, this.myActionId2Abbreviations);
        if (fromPluginXml) {
            AbbreviationManagerImpl.register(abbreviation, actionId, this.myPluginsActionId2Abbreviations);
        }
        if (!(ids = this.myAbbreviation2ActionId.computeIfAbsent(abbreviation, k -> new ArrayList(0))).contains(actionId)) {
            ids.add(actionId);
        }
    }

    public void register(@NotNull String abbreviation, @NotNull String actionId) {
        this.register(abbreviation, actionId, false);
    }

    public void remove(@NotNull String abbreviation, @NotNull String actionId) {
        Set<String> abbreviations;
        List<String> actions = this.myAbbreviation2ActionId.get(abbreviation);
        if (actions != null) {
            actions.remove(actionId);
        }
        if ((abbreviations = this.myActionId2Abbreviations.get(actionId)) != null) {
            abbreviations.remove(abbreviation);
        } else {
            Set<String> abbrs = this.myActionId2Abbreviations.get(actionId);
            if (abbrs != null) {
                LinkedHashSet<String> customValues = new LinkedHashSet<String>(abbrs);
                customValues.remove(abbreviation);
                this.myActionId2Abbreviations.put(actionId, customValues);
            }
        }
    }

    public void removeAllAbbreviations(@NotNull String actionId) {
        Set<String> abbreviations = this.getAbbreviations(actionId);
        for (String abbreviation : abbreviations) {
            this.myAbbreviation2ActionId.get(abbreviation).remove(actionId);
        }
        this.myActionId2Abbreviations.remove(actionId);
    }
}

