/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendableAction
extends AnAction {
    @NotNull
    private final ExtensionPointName<AnActionExtensionProvider> myExtensionPoint;

    public ExtendableAction(@NotNull ExtensionPointName<AnActionExtensionProvider> extensionPoint) {
        this.myExtensionPoint = extensionPoint;
    }

    public final void update(@NotNull AnActionEvent e) {
        e.getPresentation().copyFrom(this.getTemplatePresentation());
        AnActionExtensionProvider provider = this.getProvider(e);
        if (provider != null) {
            provider.update(e);
        } else {
            this.defaultUpdate(e);
        }
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        AnActionExtensionProvider provider = this.getProvider(e);
        if (provider != null) {
            provider.actionPerformed(e);
        } else {
            this.defaultActionPerformed(e);
        }
    }

    @Nullable
    private AnActionExtensionProvider getProvider(@NotNull AnActionEvent e) {
        return (AnActionExtensionProvider)this.myExtensionPoint.findFirstSafe(provider -> provider.isActive(e));
    }

    protected void defaultUpdate(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(false);
    }

    protected void defaultActionPerformed(@NotNull AnActionEvent e) {
    }
}

