/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\u0011J\u0006\u0010*\u001a\u00020(J\u0006\u0010+\u001a\u00020(J\b\u0010,\u001a\u00020\rH\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015R$\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u0013\"\u0004\b\u001a\u0010\u0015R$\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u0015R\u0011\u0010\u001e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u000f\"\u0004\b#\u0010$R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010 \"\u0004\b&\u0010\u0004\u00a8\u0006-"}, d2={"Lcom/intellij/notification/impl/ui/NotificationSettingsWrapper;", "", "version", "Lcom/intellij/notification/impl/NotificationSettings;", "(Lcom/intellij/notification/impl/NotificationSettings;)V", "type", "Lcom/intellij/notification/NotificationDisplayType;", "displayType", "getDisplayType", "()Lcom/intellij/notification/NotificationDisplayType;", "setDisplayType", "(Lcom/intellij/notification/NotificationDisplayType;)V", "groupId", "", "getGroupId", "()Ljava/lang/String;", "playSound", "", "isPlaySound", "()Z", "setPlaySound", "(Z)V", "isRemoved", "setRemoved", "shouldLog", "isShouldLog", "setShouldLog", "readAloud", "isShouldReadAloud", "setShouldReadAloud", "originalSettings", "getOriginalSettings", "()Lcom/intellij/notification/impl/NotificationSettings;", "title", "getTitle", "setTitle", "(Ljava/lang/String;)V", "getVersion", "setVersion", "apply", "", "hasChanged", "remove", "reset", "toString", "intellij.platform.ide.impl"})
public final class NotificationSettingsWrapper {
    private boolean isRemoved;
    @Nullable
    private String title;
    @NotNull
    private NotificationSettings version;

    public final boolean isRemoved() {
        return this.isRemoved;
    }

    public final void setRemoved(boolean bl) {
        this.isRemoved = bl;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable String string) {
        this.title = string;
    }

    public final boolean hasChanged() {
        return this.isRemoved || Intrinsics.areEqual((Object)this.getOriginalSettings(), (Object)this.version) ^ true;
    }

    public final void remove() {
        this.isRemoved = true;
    }

    @NotNull
    public final NotificationSettings getOriginalSettings() {
        return NotificationsConfigurationImpl.getSettings(this.getGroupId());
    }

    public final void apply() {
        if (this.isRemoved) {
            NotificationsConfigurationImpl.remove(this.getGroupId());
        } else {
            NotificationsConfigurationImpl.getInstanceImpl().changeSettings(this.version);
        }
    }

    public final void reset() {
        this.version = this.getOriginalSettings();
        this.isRemoved = false;
    }

    @NotNull
    public final String getGroupId() {
        return this.version.getGroupId();
    }

    @NotNull
    public String toString() {
        if (this.title == null) {
            String groupId2 = this.getGroupId();
            String title = NotificationGroup.Companion.getGroupTitle(groupId2);
            String string = title;
            if (string == null) {
                string = groupId2;
            }
            return string;
        }
        String string = this.title;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    public final boolean isShouldLog() {
        return this.version.isShouldLog();
    }

    public final void setShouldLog(boolean shouldLog) {
        this.version = this.version.withShouldLog(shouldLog);
    }

    public final boolean isShouldReadAloud() {
        return this.version.isShouldReadAloud();
    }

    public final void setShouldReadAloud(boolean readAloud) {
        this.version = this.version.withShouldReadAloud(readAloud);
    }

    public final boolean isPlaySound() {
        return this.version.isPlaySound();
    }

    public final void setPlaySound(boolean playSound) {
        this.version = this.version.withPlaySound(playSound);
    }

    @NotNull
    public final NotificationDisplayType getDisplayType() {
        return this.version.getDisplayType();
    }

    public final void setDisplayType(@NotNull NotificationDisplayType type) {
        this.version = this.version.withDisplayType(type);
    }

    @NotNull
    public final NotificationSettings getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull NotificationSettings notificationSettings) {
        this.version = notificationSettings;
    }

    public NotificationSettingsWrapper(@NotNull NotificationSettings version2) {
        this.version = version2;
    }
}

