/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NotificationConfiguration", storages={@Storage(value="notifications.xml")})
public final class NotificationsConfigurationImpl
extends NotificationsConfiguration
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(NotificationsConfiguration.class);
    private static final String SHOW_BALLOONS_ATTRIBUTE = "showBalloons";
    private static final String SYSTEM_NOTIFICATIONS_ATTRIBUTE = "systemNotifications";
    private static final Comparator<NotificationSettings> NOTIFICATION_SETTINGS_COMPARATOR = (o1, o2) -> o1.getGroupId().compareToIgnoreCase(o2.getGroupId());
    private final Map<String, NotificationSettings> myIdToSettingsMap = new THashMap();
    private final Map<String, String> myToolWindowCapable = new THashMap();
    public boolean SHOW_BALLOONS = true;
    public boolean SYSTEM_NOTIFICATIONS = true;

    public static NotificationsConfigurationImpl getInstanceImpl() {
        return (NotificationsConfigurationImpl)NotificationsConfigurationImpl.getNotificationsConfiguration();
    }

    public synchronized boolean hasToolWindowCapability(@NotNull String groupId2) {
        return this.getToolWindowId(groupId2) != null || this.myToolWindowCapable.containsKey(groupId2);
    }

    @Nullable
    public String getToolWindowId(@NotNull String groupId2) {
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId2);
        return group == null ? null : group.getToolWindowId();
    }

    public synchronized NotificationSettings[] getAllSettings() {
        THashSet settings = new THashSet(this.myIdToSettingsMap.values());
        for (NotificationGroup group : NotificationGroup.getAllRegisteredGroups()) {
            if (group.getDisplayId().startsWith("LIGHTWEIGHT")) continue;
            settings.add(NotificationsConfigurationImpl.getSettings(group.getDisplayId()));
        }
        NotificationSettings[] result2 = settings.toArray(new NotificationSettings[0]);
        Arrays.sort(result2, NOTIFICATION_SETTINGS_COMPARATOR);
        return result2;
    }

    public static void remove(String ... toRemove2) {
        NotificationsConfigurationImpl.getInstanceImpl().doRemove(toRemove2);
    }

    private synchronized void doRemove(String ... toRemove2) {
        for (String groupId2 : toRemove2) {
            this.myIdToSettingsMap.remove(groupId2);
            this.myToolWindowCapable.remove(groupId2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static NotificationSettings getSettings(@NotNull String groupId2) {
        NotificationSettings settings;
        NotificationsConfigurationImpl impl;
        NotificationsConfigurationImpl notificationsConfigurationImpl = impl = NotificationsConfigurationImpl.getInstanceImpl();
        synchronized (notificationsConfigurationImpl) {
            settings = impl.myIdToSettingsMap.get(groupId2);
        }
        return settings == null ? NotificationsConfigurationImpl.getDefaultSettings(groupId2) : settings;
    }

    @NotNull
    private static NotificationSettings getDefaultSettings(String groupId2) {
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId2);
        if (group != null) {
            return new NotificationSettings(groupId2, group.getDisplayType(), group.isLogByDefault(), false);
        }
        return new NotificationSettings(groupId2, NotificationDisplayType.BALLOON, true, false);
    }

    public synchronized void dispose() {
        this.myIdToSettingsMap.clear();
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType) {
        this.register(groupDisplayName, displayType, true);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog) {
        this.register(groupDisplayName, displayType, shouldLog, false);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        if (!this.isRegistered(groupDisplayName)) {
            new NotificationGroup(groupDisplayName, displayType, shouldLog);
            this.changeSettings(groupDisplayName, displayType, shouldLog, shouldReadAloud);
        } else if (displayType == NotificationDisplayType.TOOL_WINDOW && !this.hasToolWindowCapability(groupDisplayName)) {
            this.changeSettings(NotificationsConfigurationImpl.getSettings(groupDisplayName).withDisplayType(NotificationDisplayType.TOOL_WINDOW));
            this.myToolWindowCapable.put(groupDisplayName, null);
        }
    }

    public void changeSettings(String groupDisplayName, NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        this.changeSettings(new NotificationSettings(groupDisplayName, displayType, shouldLog, shouldReadAloud));
    }

    public synchronized void changeSettings(NotificationSettings settings) {
        String groupDisplayName = settings.getGroupId();
        if (settings.equals(NotificationsConfigurationImpl.getDefaultSettings(groupDisplayName))) {
            this.myIdToSettingsMap.remove(groupDisplayName);
        } else {
            this.myIdToSettingsMap.put(groupDisplayName, settings);
        }
    }

    public synchronized boolean isRegistered(@NotNull String id2) {
        return this.myIdToSettingsMap.containsKey(id2) || NotificationGroup.findRegisteredGroup((String)id2) != null;
    }

    public synchronized Element getState() {
        Element element2 = new Element("NotificationsConfiguration");
        NotificationSettings[] sortedNotifications = this.myIdToSettingsMap.values().toArray(new NotificationSettings[0]);
        Arrays.sort(sortedNotifications, NOTIFICATION_SETTINGS_COMPARATOR);
        for (NotificationSettings settings : sortedNotifications) {
            element2.addContent(settings.save());
        }
        if (!this.SHOW_BALLOONS) {
            element2.setAttribute(SHOW_BALLOONS_ATTRIBUTE, "false");
        }
        if (!this.SYSTEM_NOTIFICATIONS) {
            element2.setAttribute(SYSTEM_NOTIFICATIONS_ATTRIBUTE, "false");
        }
        return element2;
    }

    public synchronized void loadState(@NotNull Element state) {
        this.myIdToSettingsMap.clear();
        for (Element child2 : state.getChildren("notification")) {
            NotificationSettings settings = NotificationSettings.Companion.load(child2);
            if (settings == null) continue;
            String id2 = settings.getGroupId();
            LOG.assertTrue(!this.myIdToSettingsMap.containsKey(id2), (Object)String.format("Settings for '%s' already loaded!", id2));
            this.myIdToSettingsMap.put(id2, settings);
        }
        this.doRemove("Log Only");
        if ("false".equals(state.getAttributeValue(SHOW_BALLOONS_ATTRIBUTE))) {
            this.SHOW_BALLOONS = false;
        }
        if ("false".equals(state.getAttributeValue(SYSTEM_NOTIFICATIONS_ATTRIBUTE))) {
            this.SYSTEM_NOTIFICATIONS = false;
        }
    }

    static final class MyNotificationListener
    implements Notifications {
        MyNotificationListener() {
        }

        public void notify(@NotNull Notification notification) {
            NotificationsConfigurationImpl.getInstanceImpl().notify(notification);
        }
    }
}

