/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.EventLog;
import com.intellij.notification.EventLogConsole;
import com.intellij.notification.impl.NotificationsConfigurable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.AbstractLayoutManager;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class EventLogToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        EventLog.getProjectService(project).initDefaultContent();
        toolWindow.setHelpId("reference.toolwindows.event.log");
    }

    static void createContent(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull EventLogConsole console, @NotNull String title) {
        ContentManager contentManager2 = toolWindow.getContentManager();
        Content generalContent = contentManager2.getContent(0);
        if (generalContent != null && contentManager2.getContentCount() == 1) {
            generalContent.setDisplayName(CommonBundle.message((String)"tab.title.general", (Object[])new Object[0]));
        }
        final Editor editor = console.getConsoleEditor();
        JPanel editorPanel = new JPanel((LayoutManager)new AbstractLayoutManager(){

            private int getOffset() {
                return JBUIScale.scale((int)4);
            }

            public Dimension preferredLayoutSize(Container parent) {
                Dimension size = parent.getComponent(0).getPreferredSize();
                return new Dimension(size.width + this.getOffset(), size.height);
            }

            public void layoutContainer(Container parent) {
                int offset = this.getOffset();
                parent.getComponent(0).setBounds(offset, 0, parent.getWidth() - offset, parent.getHeight());
            }
        }){

            @Override
            public Color getBackground() {
                return ((EditorEx)editor).getBackgroundColor();
            }
        };
        editorPanel.add(editor.getComponent());
        SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true){

            public Object getData(@NotNull @NonNls String dataId) {
                return PlatformDataKeys.HELP_ID.is(dataId) ? "reference.toolwindows.event.log" : super.getData(dataId);
            }
        };
        panel2.setContent((JComponent)editorPanel);
        panel2.addAncestorListener((AncestorListener)((Object)new LogShownTracker(project)));
        ActionToolbar toolbar = EventLogToolWindowFactory.createToolbar(project, console);
        toolbar.setTargetComponent(editor.getContentComponent());
        panel2.setToolbar(toolbar.getComponent());
        Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel2, title, false);
        contentManager2.addContent(content2);
        contentManager2.setSelectedContent(content2);
    }

    private static ActionToolbar createToolbar(Project project, EventLogConsole console) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("MarkNotificationsAsRead"));
        group.add((AnAction)new EventLogConsole.ClearLogAction(console));
        group.addSeparator();
        group.add((AnAction)new EditNotificationSettings(project));
        return ActionManager.getInstance().createActionToolbar("EventLog", (ActionGroup)group, false);
    }

    private static final class LogShownTracker
    extends AncestorListenerAdapter {
        private final Project myProject;

        LogShownTracker(Project project) {
            this.myProject = project;
        }

        public void ancestorAdded(AncestorEvent event) {
            ToolWindow log = EventLog.getEventLog(this.myProject);
            if (log != null && log.isVisible()) {
                EventLog.getLogModel(this.myProject).logShown();
            }
        }
    }

    protected static class ToggleSoftWraps
    extends ToggleUseSoftWrapsToolbarAction {
        private final Editor myEditor;

        public ToggleSoftWraps(Editor editor) {
            super(SoftWrapAppliancePlaces.CONSOLE);
            this.myEditor = editor;
        }

        @Override
        protected Editor getEditor(@NotNull AnActionEvent e) {
            return this.myEditor;
        }
    }

    private static class EditNotificationSettings
    extends DumbAwareAction {
        private final Project myProject;

        EditNotificationSettings(Project project) {
            super(IdeBundle.message((String)"action.text.settings", (Object[])new Object[0]), IdeBundle.message((String)"action.description.edit.notification.settings", (Object[])new Object[0]), AllIcons.General.Settings);
            this.myProject = project;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)new NotificationsConfigurable());
        }
    }
}

