/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReferenceProviderBean;
import com.intellij.model.psi.impl.LanguageReferenceProviders;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ReferenceProviders {
    private static final ExtensionPointName<PsiSymbolReferenceProviderBean> EP_NAME = new ExtensionPointName("com.intellij.psi.symbolReferenceProvider");
    @NotNull
    private static final Function<Language, LanguageReferenceProviders> VALUE_MAPPER = ReferenceProviders::byLanguageInner;

    @NotNull
    static LanguageReferenceProviders byLanguage(@NotNull Language language) {
        return (LanguageReferenceProviders)EP_NAME.computeIfAbsent((Object)language, VALUE_MAPPER);
    }

    @NotNull
    private static LanguageReferenceProviders byLanguageInner(@NotNull Language language) {
        ArrayList<PsiSymbolReferenceProviderBean> result2 = new ArrayList<PsiSymbolReferenceProviderBean>();
        for (PsiSymbolReferenceProviderBean bean : EP_NAME.getExtensionList()) {
            Language hostLanguage = bean.getHostLanguage();
            boolean matches2 = hostLanguage instanceof MetaLanguage ? ((MetaLanguage)hostLanguage).matchesLanguage(language) : hostLanguage == Language.ANY || language.isKindOf(hostLanguage);
            if (!matches2) continue;
            result2.add(bean);
        }
        return new LanguageReferenceProviders(result2);
    }

    @NotNull
    public static List<PsiSymbolReferenceProviderBean> byTargetClass(@NotNull Class<? extends Symbol> targetClass) {
        return EP_NAME.getByGroupingKey(targetClass, ReferenceProviders.class, bean -> bean.getResolveTargetClass().isAssignableFrom(targetClass) ? targetClass : null);
    }
}

