/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.presentation.impl;

import com.intellij.codeInsight.navigation.PsiElementTargetPopupPresentation;
import com.intellij.ide.TypePresentationService;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.model.Symbol;
import com.intellij.model.presentation.PresentableSymbol;
import com.intellij.model.presentation.SymbolPresentation;
import com.intellij.model.presentation.SymbolPresentationProvider;
import com.intellij.model.presentation.SymbolPresentationService;
import com.intellij.model.presentation.impl.DefaultSymbolPresentation;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.navigation.TargetPopupPresentation;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageViewUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/model/presentation/impl/SymbolPresentationServiceImpl;", "Lcom/intellij/model/presentation/SymbolPresentationService;", "()V", "getPopupPresentation", "Lcom/intellij/navigation/TargetPopupPresentation;", "symbol", "Lcom/intellij/model/Symbol;", "getSymbolPresentation", "Lcom/intellij/model/presentation/SymbolPresentation;", "Companion", "intellij.platform.lang.impl"})
public final class SymbolPresentationServiceImpl
implements SymbolPresentationService {
    private static final ClassExtension<SymbolPresentationProvider> ourExtension;
    public static final Companion Companion;

    @NotNull
    public SymbolPresentation getSymbolPresentation(@NotNull Symbol symbol) {
        String string;
        for (SymbolPresentationProvider provider : ourExtension.forKey(symbol.getClass())) {
            SymbolPresentation presentation2 = provider.getPresentation(symbol);
            if (presentation2 == null) continue;
            return presentation2;
        }
        if (symbol instanceof PresentableSymbol) {
            return ((PresentableSymbol)symbol).getSymbolPresentation();
        }
        PsiElement element2 = PsiSymbolService.getInstance().extractElementFromSymbol(symbol);
        if (element2 != null) {
            return new DefaultSymbolPresentation(element2.getIcon(0), UsageViewUtil.getType(element2), UsageViewUtil.getShortName(element2), DescriptiveNameUtil.getDescriptiveName((PsiElement)element2));
        }
        TypePresentationService typePresentationService = TypePresentationService.getService();
        Icon icon2 = typePresentationService.getIcon((Object)symbol);
        String string2 = typePresentationService.getTypeName((Object)symbol);
        if (string2 == null) {
            string2 = TypePresentationService.getDefaultTypeName(symbol.getClass());
        }
        if ((string = typePresentationService.getObjectName((Object)symbol)) == null) {
            string = "<anonymous>";
        }
        return new DefaultSymbolPresentation(icon2, string2, string, null, 8, null);
    }

    @NotNull
    public TargetPopupPresentation getPopupPresentation(@NotNull Symbol symbol) {
        TargetPopupPresentation popupPresentation;
        for (SymbolPresentationProvider provider : ourExtension.forKey(symbol.getClass())) {
            TargetPopupPresentation targetPopupPresentation = provider.getPopupPresentation(symbol);
            if (targetPopupPresentation == null) {
                continue;
            }
            return targetPopupPresentation;
        }
        if (symbol instanceof PresentableSymbol && (popupPresentation = ((PresentableSymbol)symbol).getPopupPresentation()) != null) {
            return popupPresentation;
        }
        PsiElement element2 = PsiSymbolService.getInstance().extractElementFromSymbol(symbol);
        if (element2 != null) {
            return new PsiElementTargetPopupPresentation(element2);
        }
        SymbolPresentation symbolPresentation = this.getSymbolPresentation(symbol);
        return new TargetPopupPresentation(symbolPresentation){
            final /* synthetic */ SymbolPresentation $symbolPresentation;

            @Nullable
            public Icon getIcon() {
                return this.$symbolPresentation.getIcon();
            }

            @NotNull
            public String getPresentableText() {
                return this.$symbolPresentation.getLongDescription();
            }
            {
                this.$symbolPresentation = $captured_local_variable$0;
            }
        };
    }

    static {
        Companion = new Companion(null);
        ourExtension = new ClassExtension("com.intellij.symbolPresentation");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/model/presentation/impl/SymbolPresentationServiceImpl$Companion;", "", "()V", "ourExtension", "Lcom/intellij/openapi/util/ClassExtension;", "Lcom/intellij/model/presentation/SymbolPresentationProvider;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

