/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.pico.DefaultPicoContainer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;

public class MockProject
extends MockComponentManager
implements Project {
    private static final Logger LOG = Logger.getInstance(MockProject.class);
    private VirtualFile myBaseDir;

    public MockProject(@Nullable PicoContainer parent, @NotNull Disposable parentDisposable) {
        super(parent, parentDisposable);
    }

    @Override
    @NotNull
    public Condition<?> getDisposed() {
        return o -> this.isDisposed();
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isInitialized() {
        return true;
    }

    public VirtualFile getProjectFile() {
        return null;
    }

    @NotNull
    public String getName() {
        return "";
    }

    @NotNull
    @NonNls
    public String getLocationHash() {
        return "mock";
    }

    @Nullable
    public @SystemIndependent String getProjectFilePath() {
        return null;
    }

    public VirtualFile getWorkspaceFile() {
        return null;
    }

    public void setBaseDir(VirtualFile baseDir) {
        this.myBaseDir = baseDir;
    }

    @Nullable
    public VirtualFile getBaseDir() {
        return this.myBaseDir;
    }

    @Nullable
    public @SystemIndependent String getBasePath() {
        return null;
    }

    public void save() {
    }

    @NotNull
    public <T> List<T> getComponentInstancesOfType(@NotNull Class<T> componentType, boolean createIfNotYet) {
        ArrayList result2 = new ArrayList();
        DefaultPicoContainer container2 = (DefaultPicoContainer)this.getPicoContainer();
        for (ComponentAdapter componentAdapter : container2.unsafeGetAdapters()) {
            if (!ReflectionUtil.isAssignable(componentType, (Class)componentAdapter.getComponentImplementation())) continue;
            ContainerUtil.addIfNotNull(result2, (Object)componentAdapter.getComponentInstance((PicoContainer)container2));
        }
        return result2;
    }

    public void projectOpened() {
        for (ProjectComponent component2 : this.getComponentInstancesOfType(ProjectComponent.class)) {
            try {
                component2.projectOpened();
            }
            catch (Throwable e) {
                LOG.error(component2.toString(), e);
            }
        }
    }
}

