/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityInvokator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.AnyModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import java.awt.Component;
import java.lang.reflect.Modifier;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class MockApplication
extends MockComponentManager
implements ApplicationEx {
    public static int INSTANCES_CREATED;

    public MockApplication(@NotNull Disposable parentDisposable) {
        super(null, parentDisposable);
        ++INSTANCES_CREATED;
        Extensions.setRootArea((ExtensionsAreaImpl)this.getExtensionArea(), (Disposable)parentDisposable);
    }

    @NotNull
    public static MockApplication setUp(@NotNull Disposable parentDisposable) {
        MockApplication app = new MockApplication(parentDisposable);
        ApplicationManager.setApplication((Application)app, (Disposable)parentDisposable);
        return app;
    }

    @Nullable
    public final <T> T getServiceIfCreated(@NotNull Class<T> serviceClass) {
        return this.doGetService(serviceClass, false);
    }

    @Override
    public final <T> T getService(@NotNull Class<T> serviceClass) {
        return this.doGetService(serviceClass, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doGetService(@NotNull Class<T> serviceClass, boolean createIfNeeded) {
        T service = super.getService(serviceClass);
        if (service == null && createIfNeeded && Modifier.isFinal(serviceClass.getModifiers()) && serviceClass.isAnnotationPresent(Service.class)) {
            Class<T> clazz = serviceClass;
            synchronized (clazz) {
                service = super.getService(serviceClass);
                if (service != null) {
                    return service;
                }
                this.getPicoContainer().registerComponentImplementation((Object)serviceClass.getName(), serviceClass);
                return super.getService(serviceClass);
            }
        }
        return service;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isEAP() {
        return false;
    }

    public boolean isDispatchThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public boolean isWriteThread() {
        return true;
    }

    public boolean isActive() {
        return true;
    }

    public void assertReadAccessAllowed() {
    }

    public void assertWriteAccessAllowed() {
    }

    public void assertIsDispatchThread() {
    }

    public void assertIsWriteThread() {
    }

    public boolean isReadAccessAllowed() {
        return true;
    }

    public boolean isWriteAccessAllowed() {
        return true;
    }

    public boolean isUnitTestMode() {
        return true;
    }

    public boolean isHeadlessEnvironment() {
        return true;
    }

    public boolean isCommandLine() {
        return true;
    }

    @NotNull
    public Future<?> executeOnPooledThread(@NotNull Runnable action2) {
        return PooledThreadExecutor.INSTANCE.submit(action2);
    }

    @NotNull
    public <T> Future<T> executeOnPooledThread(@NotNull Callable<T> action2) {
        return PooledThreadExecutor.INSTANCE.submit(action2);
    }

    public boolean isRestartCapable() {
        return false;
    }

    public void invokeLaterOnWriteThread(@NotNull Runnable action2) {
        action2.run();
    }

    public void invokeLaterOnWriteThread(Runnable action2, ModalityState modal) {
        action2.run();
    }

    public void invokeLaterOnWriteThread(Runnable action2, ModalityState modal, @NotNull Condition<?> expired) {
        action2.run();
    }

    public void runReadAction(@NotNull Runnable action2) {
        action2.run();
    }

    public <T> T runReadAction(@NotNull Computable<T> computation) {
        return (T)computation.compute();
    }

    public <T, E extends Throwable> T runReadAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        return (T)computation.compute();
    }

    public void runWriteAction(@NotNull Runnable action2) {
        action2.run();
    }

    public <T> T runWriteAction(@NotNull Computable<T> computation) {
        return (T)computation.compute();
    }

    public <T, E extends Throwable> T runWriteAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        return (T)computation.compute();
    }

    @NotNull
    public AccessToken acquireReadActionLock() {
        return AccessToken.EMPTY_ACCESS_TOKEN;
    }

    @NotNull
    public AccessToken acquireWriteActionLock(@Nullable Class<?> marker) {
        return AccessToken.EMPTY_ACCESS_TOKEN;
    }

    public boolean hasWriteAction(@NotNull Class<?> actionClass) {
        return false;
    }

    public void addApplicationListener(@NotNull ApplicationListener listener2) {
    }

    public void addApplicationListener(@NotNull ApplicationListener listener2, @NotNull Disposable parent) {
    }

    public void removeApplicationListener(@NotNull ApplicationListener listener2) {
    }

    public long getStartTime() {
        return 0L;
    }

    public long getIdleTime() {
        return 0L;
    }

    @NotNull
    public ModalityState getNoneModalityState() {
        return ModalityState.NON_MODAL;
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull Condition<?> expired) {
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state, @NotNull Condition<?> expired) {
    }

    public void invokeLater(@NotNull Runnable runnable2) {
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state) {
    }

    @NotNull
    public ModalityInvokator getInvokator() {
        throw new UnsupportedOperationException();
    }

    public void invokeAndWait(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (this.isDispatchThread()) {
            runnable2.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable2);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void invokeAndWait(@NotNull Runnable runnable2) throws ProcessCanceledException {
        this.invokeAndWait(runnable2, this.getDefaultModalityState());
    }

    @NotNull
    public ModalityState getCurrentModalityState() {
        return this.getNoneModalityState();
    }

    @NotNull
    public ModalityState getAnyModalityState() {
        return AnyModalityState.ANY;
    }

    @NotNull
    public ModalityState getModalityStateForComponent(@NotNull Component c) {
        return this.getNoneModalityState();
    }

    @NotNull
    public ModalityState getDefaultModalityState() {
        return this.getNoneModalityState();
    }

    public void saveAll() {
    }

    public void saveSettings() {
    }

    @Override
    public boolean holdsReadLock() {
        return false;
    }

    @Override
    public void load(@Nullable String path) {
    }

    @Override
    public void restart(boolean exitConfirmed) {
    }

    @Override
    public void restart(boolean exitConfirmed, boolean elevate) {
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull String progressTitle, boolean canBeCanceled, boolean modal, @Nullable Project project, JComponent parentComponent, String cancelText) {
        return false;
    }

    @Override
    public boolean runProcessWithProgressSynchronouslyInReadAction(@Nullable Project project, @NotNull String progressTitle, boolean canBeCanceled, String cancelText, JComponent parentComponent, @NotNull Runnable process2) {
        return false;
    }

    @Override
    public void assertIsDispatchThread(@Nullable JComponent component2) {
    }

    @Override
    public void assertTimeConsuming() {
    }

    @Override
    public boolean tryRunReadAction(@NotNull Runnable runnable2) {
        this.runReadAction(runnable2);
        return true;
    }

    @Override
    public boolean isWriteActionInProgress() {
        return false;
    }

    @Override
    public boolean isWriteActionPending() {
        return false;
    }

    @Override
    public boolean isSaveAllowed() {
        return true;
    }

    @Override
    public void setSaveAllowed(boolean value2) {
    }
}

