/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EditorColorSchemesUsagesCollector
extends ApplicationUsagesCollector {
    private static final int CURR_VERSION = 3;
    public static final String SCHEME_NAME_OTHER = "Other";
    public static final String[] KNOWN_NAMES = new String[]{"Default", "Darcula", "Obsidian", "Visual Studio", "Solarized", "Wombat", "Monkai", "XCode", "Sublime", "Oblivion", "Zenburn", "Cobalt", "Netbeans", "Eclipse", "Aptana", "Flash Builder", "IdeaLight", "High contrast", "ReSharper", "Rider"};

    public int getVersion() {
        return 3;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        EditorColorsScheme currentScheme = EditorColorsManager.getInstance().getGlobalScheme();
        HashSet<MetricEvent> usages = new HashSet<MetricEvent>();
        if (currentScheme instanceof AbstractColorsScheme) {
            AbstractColorsScheme original;
            String schemeName = currentScheme.getName();
            if (schemeName.startsWith("_@user_") && (original = ((AbstractColorsScheme)currentScheme).getOriginal()) != null) {
                schemeName = original.getName();
            }
            FeatureUsageData data2 = new FeatureUsageData().addData("scheme", EditorColorSchemesUsagesCollector.getKnownSchemeName(schemeName)).addData("is_dark", ColorUtil.isDark((Color)currentScheme.getDefaultBackground()));
            usages.add(MetricEventFactoryKt.newMetric((String)"enabled.color.scheme", (FeatureUsageData)data2));
        }
        return usages;
    }

    @NotNull
    private static String getKnownSchemeName(@NonNls @NotNull String schemeName) {
        for (String knownName : KNOWN_NAMES) {
            if (!StringUtil.toUpperCase((String)schemeName).contains(StringUtil.toUpperCase((String)knownName))) continue;
            return knownName;
        }
        return SCHEME_NAME_OTHER;
    }

    @NotNull
    public String getGroupId() {
        return "ui.editor.color.schemes";
    }
}

