/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsBuiltInWhitelist;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.EventFields;
import com.intellij.internal.statistic.eventLog.EventPair;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.FusInputEvent;
import com.intellij.internal.statistic.eventLog.VarargEventId;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionsCollectorImpl
extends ActionsCollector {
    public static final String DEFAULT_ID = "third.party";
    private static final ActionsBuiltInWhitelist ourWhitelist = ActionsBuiltInWhitelist.getInstance();
    private final Map<AnAction, String> myOtherActions = ContainerUtil.createWeakMap();

    public void record(@Nullable String actionId, @Nullable InputEvent event, @NotNull Class context) {
        String recorded = StringUtil.isNotEmpty((String)actionId) && ourWhitelist.isCustomAllowedAction(actionId) ? actionId : DEFAULT_ID;
        ActionsEventLogGroup.CUSTOM_ACTION_INVOKED.log((Object)recorded, (Object)new FusInputEvent(event, null));
    }

    public void record(@Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable Language lang) {
        ActionsCollectorImpl.recordActionInvoked(project, action2, event, Collections.singletonList(EventFields.CurrentFile.with((Object)lang)));
    }

    public static void recordActionInvoked(@Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @NotNull List<EventPair> customData) {
        ActionsCollectorImpl.record(ActionsEventLogGroup.ACTION_INVOKED, project, action2, event, customData);
    }

    public static void record(VarargEventId eventId, @Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable List<EventPair> customData) {
        if (action2 == null) {
            return;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(action2.getClass());
        ArrayList<EventPair> data2 = new ArrayList<EventPair>();
        data2.add(EventFields.PluginInfoFromInstance.with((Object)action2));
        if (event != null) {
            data2.addAll(ActionsCollectorImpl.actionEventData(event));
        }
        if (project != null) {
            data2.add(ActionsEventLogGroup.DUMB.with((Object)DumbService.isDumb((Project)project)));
        }
        if (customData != null) {
            data2.addAll(customData);
        }
        ActionsCollectorImpl.addActionClass(data2, action2, info);
        eventId.log(project, data2.toArray(new EventPair[0]));
    }

    @NotNull
    public static @NotNull List<@NotNull EventPair<?>> actionEventData(@NotNull AnActionEvent event) {
        ArrayList data2 = new ArrayList();
        data2.add(EventFields.InputEvent.with((Object)FusInputEvent.from((AnActionEvent)event)));
        data2.add(EventFields.ActionPlace.with((Object)event.getPlace()));
        data2.add(ActionsEventLogGroup.CONTEXT_MENU.with((Object)event.isFromContextMenu()));
        return data2;
    }

    @NotNull
    public static String addActionClass(@NotNull List<EventPair> data2, @NotNull AnAction action2, @NotNull PluginInfo info) {
        String actionClassName = info.isSafeToReport() ? action2.getClass().getName() : DEFAULT_ID;
        String actionId = ((ActionsCollectorImpl)ActionsCollectorImpl.getInstance()).getActionId(info, action2);
        if (action2 instanceof ActionWithDelegate) {
            Object delegate = ((ActionWithDelegate)action2).getDelegate();
            PluginInfo delegateInfo = PluginInfoDetectorKt.getPluginInfo(delegate.getClass());
            actionId = delegateInfo.isSafeToReport() ? delegate.getClass().getName() : DEFAULT_ID;
            data2.add(ActionsEventLogGroup.ACTION_CLASS.with((Object)actionId));
            data2.add(ActionsEventLogGroup.ACTION_PARENT.with((Object)actionClassName));
        } else {
            data2.add(ActionsEventLogGroup.ACTION_CLASS.with((Object)actionClassName));
        }
        data2.add(ActionsEventLogGroup.ACTION_ID.with((Object)actionId));
        return actionId;
    }

    public static void addActionClass(@NotNull FeatureUsageData data2, @NotNull AnAction action2, @NotNull PluginInfo info) {
        ArrayList<EventPair> list2 = new ArrayList<EventPair>();
        ActionsCollectorImpl.addActionClass(list2, action2, info);
        for (EventPair pair : list2) {
            data2.addData(pair.component1().getName(), pair.component2().toString());
        }
    }

    @NotNull
    private String getActionId(@NotNull PluginInfo pluginInfo, @NotNull AnAction action2) {
        if (!pluginInfo.isSafeToReport()) {
            return DEFAULT_ID;
        }
        String actionId = ActionManager.getInstance().getId(action2);
        if (actionId == null && action2 instanceof ActionIdProvider) {
            actionId = ((ActionIdProvider)action2).getId();
        }
        if (actionId != null && !ActionsCollectorImpl.canReportActionId(actionId)) {
            return action2.getClass().getName();
        }
        if (actionId == null) {
            actionId = this.myOtherActions.get(action2);
        }
        return actionId != null ? actionId : action2.getClass().getName();
    }

    public static boolean canReportActionId(@NotNull String actionId) {
        return ourWhitelist.isWhitelistedActionId(actionId);
    }

    public void onActionConfiguredByActionId(@NotNull AnAction action2, @NotNull String actionId) {
        if (ActionsCollectorImpl.canReportActionId(actionId)) {
            this.myOtherActions.put(action2, actionId);
        }
    }

    public static void onActionLoadedFromXml(@NotNull AnAction action2, @NotNull String actionId, @Nullable IdeaPluginDescriptor plugin) {
        ourWhitelist.addActionLoadedFromXml(actionId, plugin);
    }

    public static void onActionsLoadedFromKeymapXml(@NotNull Keymap keymap2, @NotNull Set<String> actionIds) {
        ourWhitelist.addActionsLoadedFromKeymapXml(keymap2, actionIds);
    }
}

