/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class IntentionsCollector {
    public static void record(@NotNull Project project, @NotNull IntentionAction action2, @NotNull Language language) {
        IntentionsCollector.recordIntentionEvent(project, action2, language, "called");
    }

    protected static void recordIntentionEvent(@NotNull Project project, @NotNull IntentionAction action2, @NotNull Language language, @NonNls String eventId) {
        Class<?> clazz = IntentionsCollector.getOriginalHandlerClass(action2);
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(clazz);
        FeatureUsageData data2 = new FeatureUsageData().addData("id", clazz.getName()).addPluginInfo(info).addLanguage(language);
        FUCounterUsageLogger.getInstance().logEvent(project, "intentions", eventId, data2);
    }

    @NotNull
    private static Class<?> getOriginalHandlerClass(@NotNull IntentionAction action2) {
        LocalQuickFix fix;
        IntentionAction handler2 = action2;
        if (action2 instanceof IntentionActionDelegate) {
            IntentionAction delegate = ((IntentionActionDelegate)action2).getDelegate();
            if (delegate != action2) {
                return IntentionsCollector.getOriginalHandlerClass(delegate);
            }
        } else if (action2 instanceof QuickFixWrapper && (fix = ((QuickFixWrapper)action2).getFix()) != action2) {
            handler2 = fix;
        }
        return handler2.getClass();
    }

    public static void reportShownIntentions(@NotNull Project project, ListPopup popup2, @NotNull Language language) {
        List values2 = popup2.getListStep().getValues();
        for (IntentionActionWithTextCaching value2 : values2) {
            IntentionsCollector.recordIntentionEvent(project, value2.getAction(), language, "shown");
        }
    }
}

