/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorContextProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UiInspectorUtil {
    private static final String PROPERTY_KEY = "UiInspectorContextProvider.Key";

    public static void registerProvider(@NotNull JComponent component2, @NotNull UiInspectorContextProvider provider) {
        component2.putClientProperty(PROPERTY_KEY, provider);
    }

    public static UiInspectorContextProvider getProvider(@NotNull Object component2) {
        if (component2 instanceof UiInspectorContextProvider) {
            return (UiInspectorContextProvider)component2;
        }
        if (component2 instanceof JComponent) {
            return (UiInspectorContextProvider)ObjectUtils.tryCast((Object)((JComponent)component2).getClientProperty(PROPERTY_KEY), UiInspectorContextProvider.class);
        }
        return null;
    }

    @Nullable
    public static String getActionId(@NotNull AnAction action2) {
        if (action2 instanceof CustomisedActionGroup) {
            action2 = ((CustomisedActionGroup)action2).getOrigin();
        }
        return ActionManager.getInstance().getId(action2);
    }

    @NotNull
    public static List<PropertyBean> collectActionGroupInfo(@NotNull String prefix, @NotNull ActionGroup group, @Nullable String place) {
        ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
        if (place != null) {
            result2.add(new PropertyBean(prefix + " Place", place, true));
        }
        String toolbarId = UiInspectorUtil.getActionId((AnAction)group);
        result2.add(new PropertyBean(prefix + " Group", toolbarId, true));
        HashSet<String> ids = new HashSet<String>();
        UiInspectorUtil.recursiveCollectGroupIds(group, ids);
        ContainerUtil.addIfNotNull(ids, (Object)toolbarId);
        if (ids.size() > 1 || ids.size() == 1 && toolbarId == null) {
            result2.add(new PropertyBean("All Groups", StringUtil.join(ids, (String)", "), true));
        }
        return result2;
    }

    @NotNull
    public static List<PropertyBean> collectAnActionInfo(@NotNull AnAction action2) {
        ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
        result2.add(new PropertyBean("Action", action2.getClass().getName(), true));
        boolean isGroup = action2 instanceof ActionGroup;
        result2.add(new PropertyBean("Action" + (isGroup ? " Group" : "") + " ID", UiInspectorUtil.getActionId(action2), true));
        ClassLoader classLoader = action2.getClass().getClassLoader();
        if (classLoader instanceof PluginClassLoader) {
            result2.add(new PropertyBean("Action Plugin ID", ((PluginClassLoader)((Object)classLoader)).getPluginId().getIdString(), true));
        }
        return result2;
    }

    private static void recursiveCollectGroupIds(@NotNull ActionGroup group, @NotNull Set<String> result2) {
        for (AnAction action2 : group.getChildren(null)) {
            if (!(action2 instanceof ActionGroup)) continue;
            ActionGroup child2 = (ActionGroup)action2;
            ContainerUtil.addIfNotNull(result2, (Object)UiInspectorUtil.getActionId((AnAction)child2));
            UiInspectorUtil.recursiveCollectGroupIds(child2, result2);
        }
    }
}

