/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.anomalies;

import com.intellij.internal.InternalActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Pair;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopAnomaliesAction
extends ActionGroup {
    private static final int LIMIT = 10;

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setText("Top 10");
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        return Holder.CHILDREN;
    }

    private static <K, V> void trimToLimit(Set<Pair<K, V>> top, int limit) {
        int k = 0;
        Iterator<Pair<K, V>> iterator2 = top.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            if (++k < limit) continue;
            iterator2.remove();
        }
    }

    private static <K, V extends Integer> String getChange(Set<Pair<K, V>> old, K key, int newResult) {
        for (Pair<K, V> oldPair : old) {
            if (oldPair.first != key) continue;
            int oldResult = (Integer)oldPair.second;
            if (oldResult == newResult) break;
            return (oldResult > newResult ? " -" : " +") + Math.abs(newResult - oldResult);
        }
        return "";
    }

    private static abstract class ResettableAction
    extends AnAction {
        protected ResettableAction(@NotNull Supplier<String> dynamicText) {
            super(dynamicText);
        }

        abstract void reset();
    }

    private static class Holder {
        private static final Comparator<Pair<?, Integer>> COMPARATOR = (o1, o2) -> {
            int i2 = (Integer)o2.getSecond() - (Integer)o1.getSecond();
            if (i2 != 0) {
                return i2;
            }
            return Integer.compare(o1.hashCode(), o2.hashCode());
        };
        private static final ResettableAction TOP_PARENTS = new ResettableAction((Supplier)InternalActionsBundle.messagePointer("action.Anonymous.text.parents", new Object[0])){
            final TreeSet<Pair<JComponent, Integer>> top = new TreeSet(Holder.access$000());
            TreeSet<Pair<JComponent, Integer>> old = new TreeSet(Holder.access$000());

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setText("Top 10 Component Parents");
            }

            @Override
            void reset() {
                this.top.clear();
                this.old.clear();
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                this.old = new TreeSet<Pair<JComponent, Integer>>((SortedSet<Pair<JComponent, Integer>>)this.top);
                this.top.clear();
                Window[] windows = Window.getWindows();
                for (Window window : windows) {
                    if (!window.isVisible() || !(window instanceof JFrame)) continue;
                    JFrame f = (JFrame)window;
                    this.checkParents((JComponent)f.getContentPane(), this.top, 10);
                }
                System.out.println("Top 10 component parents");
                for (Pair pair : this.top) {
                    System.out.println(((JComponent)pair.first).getClass().getName() + " (" + pair.second + " children)" + TopAnomaliesAction.getChange(this.old, pair.first, (Integer)pair.second));
                }
            }

            private void checkParents(JComponent component2, Set<Pair<JComponent, Integer>> top, int limit) {
                top.add((Pair<JComponent, Integer>)Pair.create((Object)component2, (Object)component2.getComponentCount()));
                TopAnomaliesAction.trimToLimit(top, limit);
                for (int i2 = 0; i2 < component2.getComponentCount(); ++i2) {
                    Component child2 = component2.getComponent(i2);
                    if (!(child2 instanceof JComponent)) continue;
                    this.checkParents((JComponent)child2, top, limit);
                }
            }
        };
        private static final ResettableAction TOP_UI_PROPERTIES = new ResettableAction((Supplier)InternalActionsBundle.messagePointer("action.Anonymous.text.clientproperties", new Object[0])){
            final TreeSet<Pair<JComponent, Integer>> top = new TreeSet(Holder.access$000());
            TreeSet<Pair<JComponent, Integer>> old = new TreeSet(Holder.access$000());

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setText("Top 10 ClientProperties");
            }

            @Override
            void reset() {
                this.top.clear();
                this.old.clear();
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                this.old = new TreeSet<Pair<JComponent, Integer>>((SortedSet<Pair<JComponent, Integer>>)this.top);
                this.top.clear();
                Window[] windows = Window.getWindows();
                for (Window window : windows) {
                    if (!window.isVisible() || !(window instanceof JFrame)) continue;
                    JFrame f = (JFrame)window;
                    this.checkClientProperties((JComponent)f.getContentPane(), this.top, 10);
                }
                System.out.println("Top 10 ClientProperties");
                for (Pair pair : this.top) {
                    System.out.println(((JComponent)pair.first).getClass().getName() + " (" + pair.second + " properties)" + TopAnomaliesAction.getChange(this.old, pair.first, (Integer)pair.second));
                }
            }

            private void checkClientProperties(JComponent component2, Set<Pair<JComponent, Integer>> top, int limit) {
                try {
                    Field clientProperties = JComponent.class.getDeclaredField("clientProperties");
                    clientProperties.setAccessible(true);
                    Object o = clientProperties.get(component2);
                    if (o != null) {
                        Method size = o.getClass().getMethod("size", new Class[0]);
                        size.setAccessible(true);
                        Object sizeResult = size.invoke(o, new Object[0]);
                        if (sizeResult instanceof Integer) {
                            top.add((Pair<JComponent, Integer>)Pair.create((Object)component2, (Object)((Integer)sizeResult)));
                            TopAnomaliesAction.trimToLimit(top, limit);
                        }
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException clientProperties) {
                    // empty catch block
                }
                for (int i2 = 0; i2 < component2.getComponentCount(); ++i2) {
                    Component child2 = component2.getComponent(i2);
                    if (!(child2 instanceof JComponent)) continue;
                    this.checkClientProperties((JComponent)child2, top, limit);
                }
            }
        };
        private static final ResettableAction RESET_THEM_ALL = new ResettableAction(() -> InternalActionsBundle.message("action.Anonymous.text.reset.statistics", new Object[0])){

            @Override
            void reset() {
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                for (ResettableAction action2 : CHILDREN) {
                    action2.reset();
                }
            }
        };
        private static final ResettableAction[] CHILDREN = new ResettableAction[]{TOP_PARENTS, TOP_UI_PROPERTIES, RESET_THEM_ALL};

        private Holder() {
        }

        static /* synthetic */ Comparator access$000() {
            return COMPARATOR;
        }
    }
}

