/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentationFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private final TokenSet myTokenSet;

    public IndentationFoldingBuilder(TokenSet tokenSet) {
        this.myTokenSet = tokenSet;
    }

    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode astNode, @NotNull Document document) {
        LinkedList descriptors = new LinkedList();
        this.collectDescriptors(astNode, descriptors);
        return descriptors.toArray(FoldingDescriptor.EMPTY);
    }

    private void collectDescriptors(@NotNull ASTNode node, @NotNull List<? super FoldingDescriptor> descriptors) {
        LinkedList<ASTNode> toProcess2 = new LinkedList<ASTNode>();
        toProcess2.add(node);
        while (!toProcess2.isEmpty()) {
            ASTNode current2 = (ASTNode)toProcess2.remove();
            if (current2.getTreeParent() != null && current2.getTextLength() > 1 && this.myTokenSet.contains(current2.getElementType())) {
                descriptors.add((FoldingDescriptor)new FoldingDescriptor(current2, current2.getTextRange()));
            }
            for (ASTNode child2 = current2.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
                toProcess2.add(child2);
            }
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        StringBuilder builder2 = new StringBuilder();
        for (ASTNode child2 = node.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            String text = child2.getText();
            if (text == null) {
                if (builder2.length() <= 0) continue;
                break;
            }
            if (!text.contains("\n")) {
                builder2.append(text);
                continue;
            }
            if (builder2.length() > 0) {
                builder2.append(text, 0, text.indexOf(10));
                break;
            }
            builder2.append(IndentationFoldingBuilder.getFirstNonEmptyLine(text));
            if (builder2.length() > 0) break;
        }
        return builder2.toString();
    }

    @NotNull
    private static String getFirstNonEmptyLine(@NotNull String text) {
        int end;
        int start2 = 0;
        while ((end = text.indexOf(10, start2)) != -1 && start2 >= end) {
            start2 = end + 1;
        }
        return end == -1 ? text.substring(start2) : text.substring(start2, end);
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        return false;
    }
}

