/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.DelegateMarker;
import com.intellij.lang.impl.PsiBuilderAdapter;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class IndentPsiBuilder
extends PsiBuilderAdapter {
    protected boolean myNewLine;
    protected int myCurrentIndent;
    protected HashMap<PsiBuilder.Marker, Integer> myIndents = new HashMap();
    protected HashMap<PsiBuilder.Marker, Boolean> myNewLines = new HashMap();

    public IndentPsiBuilder(PsiBuilder delegate) {
        super(delegate);
        this.calcInitialIndent();
    }

    private void calcInitialIndent() {
        CharSequence contents = this.myDelegate.getOriginalText();
        int pos = 0;
        this.myNewLine = true;
        this.myCurrentIndent = 0;
        block4: while (pos < contents.length()) {
            char ch = contents.charAt(pos++);
            switch (ch) {
                case '\t': 
                case ' ': {
                    ++this.myCurrentIndent;
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    this.myCurrentIndent = 0;
                    continue block4;
                }
            }
            return;
        }
    }

    @Override
    public void advanceLexer() {
        String tokenText = this.myDelegate.getTokenText();
        int tokenLength = tokenText == null ? 0 : tokenText.length();
        int whiteSpaceStart = this.getCurrentOffset() + tokenLength;
        this.myDelegate.advanceLexer();
        int whiteSpaceEnd = this.getCurrentOffset();
        String whiteSpaceText = this.myDelegate.getOriginalText().subSequence(whiteSpaceStart, whiteSpaceEnd).toString();
        int i2 = whiteSpaceText.lastIndexOf(10);
        if (i2 >= 0) {
            this.myCurrentIndent = whiteSpaceText.length() - i2 - 1;
            this.myNewLine = true;
        } else {
            this.myNewLine = false;
        }
    }

    @Override
    @NotNull
    public PsiBuilder.Marker mark() {
        PsiBuilder.Marker marker = super.mark();
        return this.createDelegateMarker(marker);
    }

    @NotNull
    public PsiBuilder.Marker markWithRollbackPossibility() {
        PsiBuilder.Marker marker = super.mark();
        PsiBuilder.Marker result2 = this.createDelegateMarker(marker);
        this.myIndents.put(result2, this.myCurrentIndent);
        this.myNewLines.put(result2, this.myNewLine);
        return result2;
    }

    protected PsiBuilder.Marker createDelegateMarker(@NotNull PsiBuilder.Marker delegate) {
        return new MyMarker(delegate);
    }

    private void unregisterMarker(PsiBuilder.Marker marker) {
        this.myIndents.remove(marker);
        this.myNewLines.remove(marker);
    }

    public boolean isNewLine() {
        return this.myNewLine;
    }

    public int getCurrentIndent() {
        return this.myCurrentIndent;
    }

    public void recalculateCurrentIndent(@NotNull IElementType eolElementType, @NotNull IElementType indentElementType) {
        int i2 = 0;
        int firstIndentOffset = this.myDelegate.getCurrentOffset();
        while (this.myDelegate.rawLookup(i2) != null && this.myDelegate.rawLookup(i2) != eolElementType) {
            firstIndentOffset = this.myDelegate.rawTokenTypeStart(i2);
            --i2;
        }
        int lastIndentOffset = firstIndentOffset;
        ++i2;
        while (this.myDelegate.rawLookup(i2) == indentElementType) {
            lastIndentOffset = this.myDelegate.rawTokenTypeStart(++i2);
        }
        this.myCurrentIndent = lastIndentOffset - firstIndentOffset;
    }

    protected class MyMarker
    extends DelegateMarker {
        public MyMarker(PsiBuilder.Marker delegate) {
            super(delegate);
        }

        @Override
        public void rollbackTo() {
            if (IndentPsiBuilder.this.myIndents.containsKey(this)) {
                IndentPsiBuilder.this.myCurrentIndent = IndentPsiBuilder.this.myIndents.get(this);
            }
            if (IndentPsiBuilder.this.myNewLines.containsKey(this)) {
                IndentPsiBuilder.this.myNewLine = IndentPsiBuilder.this.myNewLines.get(this);
            }
            IndentPsiBuilder.this.unregisterMarker(this);
            super.rollbackTo();
        }

        @Override
        public void done(@NotNull IElementType type) {
            IndentPsiBuilder.this.unregisterMarker(this);
            super.done(type);
        }

        @Override
        public void drop() {
            IndentPsiBuilder.this.unregisterMarker(this);
            super.drop();
        }

        @Override
        @NotNull
        public PsiBuilder.Marker precede() {
            IndentPsiBuilder.this.unregisterMarker(this);
            return super.precede();
        }

        @Override
        public void collapse(@NotNull IElementType type) {
            IndentPsiBuilder.this.unregisterMarker(this);
            super.collapse(type);
        }

        @Override
        public void doneBefore(@NotNull IElementType type, @NotNull PsiBuilder.Marker before) {
            IndentPsiBuilder.this.unregisterMarker(this);
            super.doneBefore(type, before);
        }

        @Override
        public void doneBefore(@NotNull IElementType type, @NotNull PsiBuilder.Marker before, @NotNull String errorMessage) {
            IndentPsiBuilder.this.unregisterMarker(this);
            super.doneBefore(type, before, errorMessage);
        }
    }
}

