/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartElementDescriptor
extends NodeDescriptor {
    private final SmartPsiElementPointer mySmartPointer;

    public SmartElementDescriptor(@NotNull Project project, @Nullable NodeDescriptor parentDescriptor, @NotNull PsiElement element2) {
        super(project, parentDescriptor);
        this.mySmartPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(element2);
    }

    @Nullable
    public final PsiElement getPsiElement() {
        return this.mySmartPointer.getElement();
    }

    public Object getElement() {
        return this.getPsiElement();
    }

    protected boolean isMarkReadOnly() {
        return this.getParentDescriptor() instanceof PsiDirectoryNode;
    }

    protected boolean isMarkModified() {
        return this.getParentDescriptor() instanceof PsiDirectoryNode;
    }

    public boolean update() {
        VirtualFile virtualFile;
        PsiElement element2 = this.mySmartPointer.getElement();
        if (element2 == null) {
            return true;
        }
        Icon icon2 = this.getIcon(element2);
        Color color = null;
        if (this.isMarkModified() && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2)) != null) {
            color = FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile).getColor();
        }
        if (CopyPasteManager.getInstance().isCutElement((Object)element2)) {
            color = CopyPasteManager.CUT_COLOR;
        }
        boolean changes = !Comparing.equal((Object)icon2, (Object)this.getIcon()) || !Comparing.equal((Object)color, (Object)this.myColor);
        this.setIcon(icon2);
        this.myColor = color;
        return changes;
    }

    @Nullable
    protected Icon getIcon(@NotNull PsiElement element2) {
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        try {
            return element2.getIcon(flags);
        }
        catch (IndexNotReadyException ignored) {
            return null;
        }
    }
}

