/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.SettingsProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeStructureBase
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance(AbstractTreeStructureBase.class);
    protected final Project myProject;

    protected AbstractTreeStructureBase(Project project) {
        this.myProject = project;
    }

    public Object @NotNull [] getChildElements(@NotNull Object element2) {
        List<TreeStructureProvider> providers;
        LOG.assertTrue(element2 instanceof AbstractTreeNode, (Object)element2.getClass().getName());
        AbstractTreeNode treeNode = (AbstractTreeNode)element2;
        Collection elements2 = treeNode.getChildren();
        if (elements2.contains(null)) {
            LOG.error("node contains null child: " + treeNode + "; " + treeNode.getClass());
        }
        List<TreeStructureProvider> list2 = providers = Registry.is((String)"allow.tree.structure.provider.in.dumb.mode") ? this.getProviders() : this.getProvidersDumbAware();
        if (providers != null && !providers.isEmpty()) {
            ViewSettings settings = treeNode instanceof SettingsProvider ? ((SettingsProvider)treeNode).getSettings() : ViewSettings.DEFAULT;
            for (TreeStructureProvider provider : providers) {
                ProgressManager.checkCanceled();
                try {
                    if (!(elements2 = provider.modify(treeNode, elements2, settings)).contains(null)) continue;
                    LOG.error("provider creates null child: " + provider);
                }
                catch (IndexNotReadyException e) {
                    LOG.debug("TreeStructureProvider.modify requires indices", (Throwable)e);
                    throw new ProcessCanceledException((Throwable)e);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        elements2.forEach(node -> node.setParent(treeNode));
        return ArrayUtil.toObjectArray((Collection)elements2);
    }

    public boolean isValid(@NotNull Object element2) {
        return element2 instanceof AbstractTreeNode;
    }

    public Object getParentElement(@NotNull Object element2) {
        if (element2 instanceof AbstractTreeNode) {
            return ((AbstractTreeNode)element2).getParent();
        }
        return null;
    }

    @NotNull
    public NodeDescriptor<?> createDescriptor(@NotNull Object element2, NodeDescriptor parentDescriptor) {
        return (NodeDescriptor)element2;
    }

    @Nullable
    public abstract List<TreeStructureProvider> getProviders();

    @Nullable
    public Object getDataFromProviders(@NotNull List<AbstractTreeNode<?>> selectedNodes, @NotNull String dataId) {
        List<TreeStructureProvider> providers = this.getProvidersDumbAware();
        if (!providers.isEmpty()) {
            for (TreeStructureProvider treeStructureProvider : providers) {
                Object fromProvider = treeStructureProvider.getData(selectedNodes, dataId);
                if (fromProvider == null) continue;
                return fromProvider;
            }
        }
        return null;
    }

    @NotNull
    private List<TreeStructureProvider> getProvidersDumbAware() {
        if (this.myProject == null) {
            return Collections.emptyList();
        }
        List<TreeStructureProvider> providers = this.getProviders();
        if (providers == null) {
            return Collections.emptyList();
        }
        return DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(providers);
    }
}

