/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.application.options.PathMacrosCollector;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExistingModuleLoader
extends ModuleBuilder {
    private static final Logger LOG = Logger.getInstance(ExistingModuleLoader.class);

    public static ExistingModuleLoader setUpLoader(String moduleFilePath) {
        ExistingModuleLoader moduleLoader = new ExistingModuleLoader();
        moduleLoader.setModuleFilePath(moduleFilePath);
        int startIndex = moduleFilePath.lastIndexOf(47);
        int endIndex = moduleFilePath.lastIndexOf(".");
        if (startIndex >= 0 && endIndex > startIndex + 1) {
            String name = moduleFilePath.substring(startIndex + 1, endIndex);
            moduleLoader.setName(name);
        }
        return moduleLoader;
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        LOG.assertTrue(this.getName() != null);
        String moduleFilePath = this.getModuleFilePath();
        LOG.assertTrue(moduleFilePath != null);
        LOG.assertTrue(new File(moduleFilePath).exists());
        return moduleModel.loadModule(moduleFilePath);
    }

    public ModuleType<?> getModuleType() {
        return null;
    }

    public boolean validate(@Nullable Project currentProject, @NotNull Project project) {
        block7: {
            if (this.getName() == null) {
                return false;
            }
            String moduleFilePath = this.getModuleFilePath();
            if (moduleFilePath == null) {
                return false;
            }
            Path file2 = Paths.get(moduleFilePath, new String[0]);
            if (Files.exists(file2, new LinkOption[0])) {
                try {
                    boolean ok;
                    ConversionResult result2 = ConversionService.getInstance().convertModule(project, file2);
                    if (result2.openingIsCanceled()) {
                        return false;
                    }
                    Element root = JDOMUtil.load((Path)file2);
                    Set<String> usedMacros = PathMacrosCollector.getMacroNames(root);
                    usedMacros.remove("$MODULE_DIR$");
                    usedMacros.removeAll(PathMacros.getInstance().getAllMacroNames());
                    if (usedMacros.size() > 0 && !(ok = ProjectMacrosUtil.showMacrosConfigurationDialog(currentProject, usedMacros))) {
                        return false;
                    }
                    break block7;
                }
                catch (IOException | JDOMException e) {
                    Messages.showMessageDialog((String)e.getMessage(), (String)IdeBundle.message((String)"title.error.reading.file", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
            }
            Messages.showErrorDialog((Project)currentProject, (String)IdeBundle.message((String)"title.module.file.does.not.exist", (Object[])new Object[]{moduleFilePath}), (String)CommonBundle.getErrorTitle());
            return false;
        }
        return true;
    }
}

