/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.FilteredQuery;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlatformPackageUtil {
    private static final Logger LOG = Logger.getInstance(PlatformPackageUtil.class);

    @Nullable
    private static String findLongestExistingPackage(Project project, String packageName, GlobalSearchScope scope) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        DirectoryIndex index = DirectoryIndex.getInstance(project);
        String nameToMatch = packageName;
        while (true) {
            Query<VirtualFile> vFiles;
            PsiDirectory directory;
            if ((directory = PlatformPackageUtil.getWritableModuleDirectory(vFiles = index.getDirectoriesByPackageName(nameToMatch, false), scope, manager)) != null) {
                return index.getPackageName(directory.getVirtualFile());
            }
            int lastDotIndex = nameToMatch.lastIndexOf(46);
            if (lastDotIndex < 0) break;
            nameToMatch = nameToMatch.substring(0, lastDotIndex);
        }
        return null;
    }

    @Nullable
    private static PsiDirectory getWritableModuleDirectory(@NotNull Query<? extends VirtualFile> vFiles, GlobalSearchScope scope, PsiManager manager) {
        for (VirtualFile vFile : vFiles) {
            PsiDirectory directory;
            if (!scope.contains(vFile) || (directory = manager.findDirectory(vFile)) == null || !directory.isValid() || !directory.isWritable()) continue;
            return directory;
        }
        return null;
    }

    @Nullable
    public static PsiDirectory findOrCreateDirectoryForPackage(@NotNull Project project, @Nullable Module module, GlobalSearchScope scope, String packageName, PsiDirectory baseDir, boolean askUserToCreate, ThreeState chooseFlag) throws IncorrectOperationException {
        String rootPackage;
        PsiDirectory psiDirectory = null;
        if (chooseFlag == ThreeState.UNSURE && StringUtil.isNotEmpty((String)packageName) && (rootPackage = PlatformPackageUtil.findLongestExistingPackage(project, packageName, scope)) != null) {
            int beginIndex = rootPackage.length() + 1;
            packageName = beginIndex < packageName.length() ? packageName.substring(beginIndex) : "";
            String postfixToShow = packageName.replace('.', File.separatorChar);
            if (packageName.length() > 0) {
                postfixToShow = File.separatorChar + postfixToShow;
            }
            if ((psiDirectory = DirectoryChooserUtil.selectDirectory(project, PlatformPackageUtil.getPackageDirectories(project, rootPackage, scope), baseDir, postfixToShow)) == null) {
                return null;
            }
        }
        if (psiDirectory == null) {
            if (chooseFlag == ThreeState.NO && baseDir != null) {
                VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(baseDir.getVirtualFile());
                psiDirectory = sourceRoot != null ? PsiManager.getInstance((Project)project).findDirectory(sourceRoot) : null;
            } else {
                if (module != null && !PlatformPackageUtil.checkSourceRootsConfigured(module)) {
                    return null;
                }
                GlobalSearchScope scope_ = scope;
                List dirs = ContainerUtil.mapNotNull((Object[])ProjectRootManager.getInstance((Project)project).getContentSourceRoots(), virtualFile -> scope_.contains(virtualFile) ? PsiManager.getInstance((Project)project).findDirectory(virtualFile) : null);
                psiDirectory = DirectoryChooserUtil.selectDirectory(project, dirs.toArray(PsiDirectory.EMPTY_ARRAY), baseDir, File.separatorChar + packageName.replace('.', File.separatorChar));
                if (psiDirectory == null) {
                    return null;
                }
                VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(psiDirectory.getVirtualFile());
                psiDirectory = sourceRoot != null ? PsiManager.getInstance((Project)project).findDirectory(sourceRoot) : null;
            }
        }
        String restOfName = packageName;
        boolean askedToCreate = false;
        while (restOfName.length() > 0) {
            PsiDirectory foundExistingDirectory;
            String name = PlatformPackageUtil.getLeftPart(restOfName);
            PsiDirectory psiDirectory2 = foundExistingDirectory = psiDirectory != null ? psiDirectory.findSubdirectory(name) : null;
            if (foundExistingDirectory == null) {
                if (!askedToCreate && askUserToCreate) {
                    int toCreate;
                    if (!ApplicationManager.getApplication().isUnitTestMode() && (toCreate = Messages.showYesNoDialog((Project)project, (String)IdeBundle.message((String)"prompt.create.non.existing.package", (Object[])new Object[]{packageName}), (String)IdeBundle.message((String)"title.package.not.found", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
                        return null;
                    }
                    askedToCreate = true;
                }
                PsiDirectory psiDirectory_ = psiDirectory;
                try {
                    psiDirectory = (PsiDirectory)WriteAction.compute(() -> psiDirectory_ != null ? psiDirectory_.createSubdirectory(name) : null);
                }
                catch (IncorrectOperationException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            } else {
                psiDirectory = foundExistingDirectory;
            }
            restOfName = PlatformPackageUtil.cutLeftPart(restOfName);
        }
        return psiDirectory;
    }

    public static GlobalSearchScope adjustScope(PsiDirectory baseDir, GlobalSearchScope scope, boolean skipSourceDirsForBaseTestDirectory, boolean skipTestDirsForBaseSourceDirectory) {
        if (baseDir != null) {
            if (TestSourcesFilter.isTestSources((VirtualFile)baseDir.getVirtualFile(), (Project)baseDir.getProject())) {
                if (skipSourceDirsForBaseTestDirectory) {
                    return scope.intersectWith(GlobalSearchScopesCore.projectTestScope((Project)baseDir.getProject()));
                }
            } else if (skipTestDirsForBaseSourceDirectory) {
                return scope.intersectWith(GlobalSearchScopesCore.projectProductionScope((Project)baseDir.getProject()));
            }
        }
        return scope;
    }

    private static PsiDirectory[] getPackageDirectories(Project project, String rootPackage, GlobalSearchScope scope) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        FilteredQuery query = DirectoryIndex.getInstance(scope.getProject()).getDirectoriesByPackageName(rootPackage, true);
        query = new FilteredQuery(query, arg_0 -> ((GlobalSearchScope)scope).contains(arg_0));
        List directories = ContainerUtil.mapNotNull((Collection)query.findAll(), arg_0 -> ((PsiManager)manager).findDirectory(arg_0));
        return directories.toArray(PsiDirectory.EMPTY_ARRAY);
    }

    private static boolean checkSourceRootsConfigured(Module module) {
        VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
        if (sourceRoots.length == 0) {
            Messages.showErrorDialog((Project)module.getProject(), (String)ProjectBundle.message((String)"module.source.roots.not.configured.error", (Object[])new Object[]{module.getName()}), (String)ProjectBundle.message((String)"module.source.roots.not.configured.title", (Object[])new Object[0]));
            ProjectSettingsService.getInstance(module.getProject()).showModuleConfigurationDialog(module.getName(), CommonContentEntriesEditor.getName());
            sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
            if (sourceRoots.length == 0) {
                return false;
            }
        }
        return true;
    }

    private static String getLeftPart(String packageName) {
        int index = packageName.indexOf(46);
        return index > -1 ? packageName.substring(0, index) : packageName;
    }

    private static String cutLeftPart(String packageName) {
        int index = packageName.indexOf(46);
        return index > -1 ? packageName.substring(index + 1) : "";
    }

    @Nullable
    public static PsiDirectory getDirectory(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        PsiFile file2 = FileContextUtil.getContextFile(element2);
        return file2 == null ? null : file2.getContainingDirectory();
    }
}

