/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DeleteUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeleteHandler {
    private DeleteHandler() {
    }

    public static void deletePsiElement(PsiElement[] elementsToDelete, Project project) {
        DeleteHandler.deletePsiElement(elementsToDelete, project, true);
    }

    public static void deletePsiElement(PsiElement[] elementsToDelete, final Project project, boolean needConfirmation) {
        if (elementsToDelete == null || elementsToDelete.length == 0) {
            return;
        }
        final PsiElement[] elements2 = PsiTreeUtil.filterAncestors((PsiElement[])elementsToDelete);
        boolean safeDeleteApplicable = Arrays.stream(elements2).allMatch(SafeDeleteProcessor::validElement);
        boolean dumb = DumbService.getInstance((Project)project).isDumb();
        if (safeDeleteApplicable && !dumb) {
            final Ref exit = Ref.create((Object)false);
            SafeDeleteDialog dialog2 = new SafeDeleteDialog(project, elements2, new SafeDeleteDialog.Callback(){

                @Override
                public void run(SafeDeleteDialog dialog2) {
                    if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(elements2), (boolean)true)) {
                        return;
                    }
                    SafeDeleteProcessor processor2 = SafeDeleteProcessor.createInstance(project, () -> {
                        exit.set((Object)true);
                        dialog2.close(0);
                    }, elements2, dialog2.isSearchInComments(), dialog2.isSearchForTextOccurences(), true);
                    processor2.run();
                }
            }){

                @Override
                protected boolean isDelete() {
                    return true;
                }
            };
            if (needConfirmation) {
                dialog2.setTitle(RefactoringBundle.message((String)"delete.title"));
                if (!dialog2.showAndGet() || ((Boolean)exit.get()).booleanValue()) {
                    return;
                }
            }
        } else {
            int result2;
            String warningMessage = DeleteUtil.generateWarningMessage(IdeBundle.message((String)"prompt.delete.elements", (Object[])new Object[0]), elements2);
            boolean anyDirectories = false;
            String directoryName = null;
            for (PsiElement psiElement : elementsToDelete) {
                if (!(psiElement instanceof PsiDirectory) || PsiUtilBase.isSymLink((PsiFileSystemItem)((PsiDirectory)psiElement))) continue;
                anyDirectories = true;
                directoryName = ((PsiDirectory)psiElement).getName();
                break;
            }
            if (anyDirectories) {
                warningMessage = elements2.length == 1 ? warningMessage + IdeBundle.message((String)"warning.delete.all.files.and.subdirectories", (Object[])new Object[]{directoryName}) : warningMessage + IdeBundle.message((String)"warning.delete.all.files.and.subdirectories.in.the.selected.directory", (Object[])new Object[0]);
            }
            if (safeDeleteApplicable) {
                warningMessage = warningMessage + "\n\nWarning:\n  Safe delete is not available while " + ApplicationNamesInfo.getInstance().getFullProductName() + " updates indices,\n  no usages will be checked.";
            }
            if (needConfirmation && (result2 = Messages.showOkCancelDialog((Project)project, (String)warningMessage, (String)IdeBundle.message((String)"title.delete", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) != 0) {
                return;
            }
        }
        DeleteHandler.deleteInCommand(project, elements2);
    }

    private static boolean makeWritable(Project project, PsiElement[] elements2) {
        SmartList directories = new SmartList();
        for (PsiElement e : elements2) {
            if (!(e instanceof PsiFileSystemItem) || e.getParent() == null) continue;
            directories.add(e.getParent());
        }
        return CommonRefactoringUtil.checkReadOnlyStatus((Project)project, Arrays.asList(elements2), (Collection)directories, (boolean)false);
    }

    private static void deleteInCommand(Project project, PsiElement[] elements2) {
        CommandProcessor.getInstance().executeCommand(project, () -> NonProjectFileWritingAccessProvider.disableChecksDuring(() -> {
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
            List pointers2 = ContainerUtil.map((Object[])elements2, arg_0 -> ((SmartPointerManager)smartPointerManager).createSmartPsiElementPointer(arg_0));
            if (!DeleteHandler.makeWritable(project, elements2)) {
                return;
            }
            DataContext context = DataManager.getInstance().getDataContext();
            if (CommonDataKeys.EDITOR.getData(context) == null) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
            }
            if (Stream.of(elements2).allMatch(DeleteHandler::isLocalFile)) {
                DeleteHandler.doDeleteFiles(project, elements2);
            } else {
                for (SmartPsiElementPointer pointer : pointers2) {
                    PsiElement elementToDelete = pointer.getElement();
                    if (elementToDelete == null) continue;
                    DeleteHandler.doDelete(project, elementToDelete);
                }
            }
        }), RefactoringBundle.message((String)"safe.delete.command", (Object[])new Object[]{RefactoringUIUtil.calculatePsiElementDescriptionList(elements2)}), null);
    }

    private static boolean isLocalFile(PsiElement e) {
        VirtualFile file2;
        return e instanceof PsiFileSystemItem && (file2 = ((PsiFileSystemItem)e).getVirtualFile()) != null && file2.isInLocalFileSystem();
    }

    private static boolean clearFileReadOnlyFlags(Project project, PsiElement elementToDelete) {
        VirtualFile virtualFile;
        PsiFile file2;
        if (elementToDelete instanceof PsiDirectory) {
            VirtualFile virtualFile2 = ((PsiDirectory)elementToDelete).getVirtualFile();
            if (virtualFile2.isInLocalFileSystem() && !virtualFile2.is(VFileProperty.SYMLINK)) {
                ArrayList readOnlyFiles = new ArrayList();
                CommonRefactoringUtil.collectReadOnlyFiles((VirtualFile)virtualFile2, readOnlyFiles);
                if (!readOnlyFiles.isEmpty()) {
                    VirtualFile file3;
                    String message = IdeBundle.message((String)"prompt.directory.contains.read.only.files", (Object[])new Object[]{virtualFile2.getPresentableUrl()});
                    int _result = Messages.showYesNoDialog((Project)project, (String)message, (String)IdeBundle.message((String)"title.delete", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (_result != 0) {
                        return false;
                    }
                    boolean success = true;
                    Iterator iterator2 = readOnlyFiles.iterator();
                    while (iterator2.hasNext() && (success = DeleteHandler.clearReadOnlyFlag(file3 = (VirtualFile)iterator2.next(), project))) {
                    }
                    if (!success) {
                        return false;
                    }
                }
            }
        } else if (!(elementToDelete.isWritable() || elementToDelete instanceof PsiFileSystemItem && PsiUtilBase.isSymLink((PsiFileSystemItem)((PsiFileSystemItem)elementToDelete)) || (file2 = elementToDelete.getContainingFile()) == null || !(virtualFile = file2.getVirtualFile()).isInLocalFileSystem())) {
            int _result = ((MessagesEx.MessageInfo)((MessagesEx.MessageInfo)MessagesEx.fileIsReadOnly(project, virtualFile).setTitle(IdeBundle.message((String)"title.delete", (Object[])new Object[0]))).appendMessage(" " + IdeBundle.message((String)"prompt.delete.it.anyway", (Object[])new Object[0]))).askYesNo();
            if (_result != 0) {
                return false;
            }
            boolean success = DeleteHandler.clearReadOnlyFlag(virtualFile, project);
            if (!success) {
                return false;
            }
        }
        return true;
    }

    private static void doDelete(Project project, PsiElement element2) {
        if (!DeleteHandler.clearFileReadOnlyFlags(project, element2)) {
            return;
        }
        try {
            element2.checkDelete();
        }
        catch (IncorrectOperationException e) {
            Messages.showMessageDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                element2.delete();
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon()));
            }
        });
    }

    private static void doDeleteFiles(Project project, PsiElement[] fileElements) {
        for (PsiElement file2 : fileElements) {
            if (DeleteHandler.clearFileReadOnlyFlags(project, file2)) continue;
            return;
        }
        LocalFilesDeleteTask task2 = new LocalFilesDeleteTask(project, fileElements);
        ProgressManager.getInstance().run((Task)task2);
        if (task2.error != null) {
            Messages.showMessageDialog((Project)project, (String)task2.error.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        }
        if (task2.aborted != null) {
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{task2.aborted});
        }
        if (!task2.processed.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (PsiElement fileElement : task2.processed) {
                    try {
                        fileElement.delete();
                    }
                    catch (IncorrectOperationException e) {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon()));
                    }
                }
            });
        }
    }

    private static boolean clearReadOnlyFlag(VirtualFile virtualFile, Project project) {
        boolean[] success = new boolean[1];
        CommandProcessor.getInstance().executeCommand(project, () -> {
            Runnable action2 = () -> {
                try {
                    ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)virtualFile, (boolean)false);
                    success[0] = true;
                }
                catch (IOException e1) {
                    Messages.showMessageDialog((Project)project, (String)e1.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                }
            };
            ApplicationManager.getApplication().runWriteAction(action2);
        }, "", null);
        return success[0];
    }

    public static boolean shouldEnableDeleteAction(PsiElement[] elements2) {
        if (elements2 == null || elements2.length == 0) {
            return false;
        }
        for (PsiElement element2 : elements2) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
            if (virtualFile == null || virtualFile instanceof LightVirtualFile) {
                return false;
            }
            if (WritingAccessProvider.isPotentiallyWritable((VirtualFile)virtualFile, (Project)element2.getProject())) continue;
            return false;
        }
        return true;
    }

    private static class LocalFilesDeleteTask
    extends Task.Modal {
        private final PsiElement[] myFileElements;
        List<PsiElement> processed = new ArrayList<PsiElement>();
        VirtualFile aborted = null;
        IOException error = null;

        LocalFilesDeleteTask(Project project, PsiElement[] fileElements) {
            super(project, IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]), true);
            this.myFileElements = fileElements;
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            indicator.setIndeterminate(true);
            try {
                for (PsiElement e : this.myFileElements) {
                    if (!indicator.isCanceled()) {
                        VirtualFile file2;
                        this.aborted = file2 = ((PsiFileSystemItem)e).getVirtualFile();
                        final Path path = Paths.get(file2.getPath(), new String[0]);
                        indicator.setText(path.toString());
                        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                if (SystemInfo.isWindows && attrs.isOther()) {
                                    this.visitFile(dir, (BasicFileAttributes)null);
                                    return FileVisitResult.SKIP_SUBTREE;
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file2, @Nullable BasicFileAttributes attrs) throws IOException {
                                indicator.setText2(path.relativize(file2).toString());
                                Files.delete(file2);
                                return indicator.isCanceled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                return this.visitFile(dir, (BasicFileAttributes)null);
                            }
                        });
                        if (indicator.isCanceled()) continue;
                        this.processed.add(e);
                        this.aborted = null;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.error = e;
            }
        }
    }

    public static class DefaultDeleteProvider
    implements DeleteProvider {
        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (CommonDataKeys.PROJECT.getData(dataContext) == null) {
                return false;
            }
            PsiElement[] elements2 = DefaultDeleteProvider.getPsiElements(dataContext);
            return DeleteHandler.shouldEnableDeleteAction(elements2);
        }

        private static PsiElement @Nullable [] getPsiElements(DataContext dataContext) {
            PsiElement[] elements2 = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
            if (elements2 == null) {
                PsiElement data2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
                if (data2 != null) {
                    elements2 = new PsiElement[]{data2};
                } else {
                    PsiFile data1 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
                    if (data1 != null) {
                        elements2 = new PsiElement[]{data1};
                    }
                }
            }
            return elements2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            PsiElement[] elements2 = DefaultDeleteProvider.getPsiElements(dataContext);
            if (elements2 == null) {
                return;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return;
            }
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements2, project);
            }
            finally {
                a.finish();
            }
        }
    }
}

