/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.ComboBoxPopup;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class DarculaJBPopupComboPopup<T>
implements ComboPopup,
ComboBoxPopup.Context<T>,
ItemListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
PropertyChangeListener,
AncestorListener {
    public static final String CLIENT_PROP = "ComboBox.jbPopup";
    public static final String USE_LIVE_UPDATE_MODEL = "ComboBox.jbPopup.supportUpdateModel";
    private final JComboBox<T> myComboBox;
    private final JList<T> myProxyList = new JBList();
    private ComboBoxPopup<T> myPopup;
    private boolean myJustClosedViaClick;

    public DarculaJBPopupComboPopup(@NotNull JComboBox<T> comboBox2) {
        this.myComboBox = comboBox2;
        this.myProxyList.setModel(comboBox2.getModel());
        this.myComboBox.addPropertyChangeListener(this);
        this.myComboBox.addItemListener(this);
        this.myComboBox.addAncestorListener(this);
    }

    @Override
    @Nullable
    public Project getProject() {
        return (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(this.myComboBox));
    }

    @Override
    @NotNull
    public ListModel<T> getModel() {
        return this.myComboBox.getModel();
    }

    @Override
    @NotNull
    public ListCellRenderer<? super T> getRenderer() {
        return this.myComboBox.getRenderer();
    }

    @Override
    public int getMaximumRowCount() {
        return Math.max(10, this.myComboBox.getMaximumRowCount());
    }

    @Override
    public void onPopupStepCancelled() {
        this.myComboBox.firePopupMenuCanceled();
    }

    @Override
    public void show() {
        this.myJustClosedViaClick = false;
        if (this.myPopup != null) {
            if (this.myPopup.isVisible()) {
                return;
            }
            this.myPopup.cancel();
        }
        Object selectedItem = this.myComboBox.getSelectedItem();
        this.myPopup = this.createPopup(selectedItem);
        this.myPopup.addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                DarculaJBPopupComboPopup.this.myComboBox.firePopupMenuWillBecomeVisible();
                if (DarculaJBPopupComboPopup.this.useLiveUpdateWithModel()) {
                    DarculaJBPopupComboPopup.this.myPopup.syncWithModelChange();
                }
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                DarculaJBPopupComboPopup.this.myComboBox.firePopupMenuWillBecomeInvisible();
                DarculaJBPopupComboPopup.this.myPopup = null;
                DarculaJBPopupComboPopup.this.myProxyList.setCellRenderer(new DefaultListCellRenderer());
                DarculaJBPopupComboPopup.this.myProxyList.setModel(DarculaJBPopupComboPopup.this.myComboBox.getModel());
            }
        });
        JList<T> list2 = this.myPopup.getList();
        this.myProxyList.setCellRenderer(list2.getCellRenderer());
        this.myProxyList.setModel(list2.getModel());
        this.myPopup.setMinimumSize(this.myComboBox.getSize());
        this.myPopup.showUnderneathOf(this.myComboBox);
    }

    @Override
    public void configureList(@NotNull JList<T> list2) {
        list2.setFont(this.myComboBox.getFont());
        list2.setForeground(this.myComboBox.getForeground());
        list2.setBackground(this.myComboBox.getBackground());
    }

    @Override
    public void hide() {
        this.myJustClosedViaClick = false;
        if (this.myPopup == null) {
            return;
        }
        this.myPopup.cancel();
    }

    @Override
    public boolean isVisible() {
        return this.myPopup != null && this.myPopup.isVisible();
    }

    @Override
    public JList<Object> getList() {
        return this.myProxyList;
    }

    @Override
    public MouseListener getMouseListener() {
        return this;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return this;
    }

    @Override
    public KeyListener getKeyListener() {
        return null;
    }

    @Override
    public void uninstallingUI() {
        this.myComboBox.removePropertyChangeListener(this);
        this.myComboBox.removeItemListener(this);
        this.myComboBox.removeAncestorListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        String propertyName = e.getPropertyName();
        if ("renderer".equals(propertyName) || "editable".equals(propertyName)) {
            this.hide();
        }
        if ("model".equals(propertyName) && this.myPopup != null) {
            if (!this.useLiveUpdateWithModel()) {
                this.hide();
            } else {
                this.myPopup.syncWithModelChange();
            }
        }
    }

    private boolean useLiveUpdateWithModel() {
        return Boolean.TRUE.equals(this.myComboBox.getClientProperty(USE_LIVE_UPDATE_MODEL));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.getList()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e) || !this.myComboBox.isEnabled()) {
            return;
        }
        if (this.myComboBox.isEditable()) {
            Component comp = this.myComboBox.getEditor().getEditorComponent();
            if (!(comp instanceof JComponent) || ((JComponent)comp).isRequestFocusEnabled()) {
                comp.requestFocus();
            }
        } else if (this.myComboBox.isRequestFocusEnabled()) {
            this.myComboBox.requestFocus();
        }
        if (this.myJustClosedViaClick) {
            this.myJustClosedViaClick = false;
            return;
        }
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
        this.hide();
    }

    protected ComboBoxPopup<T> createPopup(@Nullable T selectedItem) {
        return new ComboBoxPopup<T>(this, selectedItem, value2 -> this.myComboBox.setSelectedItem(value2)){

            @Override
            public void cancel(InputEvent e) {
                if (e instanceof MouseEvent) {
                    Point point = new RelativePoint((MouseEvent)e).getPoint((Component)DarculaJBPopupComboPopup.this.myComboBox);
                    DarculaJBPopupComboPopup.this.myJustClosedViaClick = new Rectangle(DarculaJBPopupComboPopup.this.myComboBox.getSize()).contains(point);
                }
                super.cancel(e);
            }
        };
    }
}

