/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.troubleshooting;

import com.intellij.openapi.project.Project;
import com.intellij.troubleshooting.GeneralTroubleInfoCollector;
import com.intellij.ui.scale.JBUIScale;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import org.jetbrains.annotations.NotNull;

public class DisplayTroubleInfoCollector
implements GeneralTroubleInfoCollector {
    @Override
    @NotNull
    public String getTitle() {
        return "Displays";
    }

    @Override
    @NotNull
    public String collectInfo(@NotNull Project project) {
        StringBuilder output = new StringBuilder();
        output.append("Displays: \n");
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int i2 = 0; i2 < devices.length; ++i2) {
            DisplayMode displayMode = devices[i2].getDisplayMode();
            float scale = JBUIScale.sysScale((GraphicsConfiguration)devices[i2].getDefaultConfiguration());
            output.append(String.format("Display %d: %2.0fx%3.0f; scale: %4$.2f\n", i2, Float.valueOf((float)displayMode.getWidth() * scale), Float.valueOf((float)displayMode.getHeight() * scale), Float.valueOf(scale)));
        }
        return output.toString();
    }
}

