/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.SmartTodoItemPointerComparator;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.search.TodoItemImpl;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TodoFileNode
extends PsiFileNode {
    private final TodoTreeBuilder myBuilder;
    private final boolean mySingleFileMode;

    public TodoFileNode(Project project, @NotNull PsiFile file2, TodoTreeBuilder treeBuilder, boolean singleFileMode) {
        super(project, file2, ViewSettings.DEFAULT);
        this.myBuilder = treeBuilder;
        this.mySingleFileMode = singleFileMode;
    }

    @Override
    public Collection<AbstractTreeNode<?>> getChildrenImpl() {
        try {
            if (!this.mySingleFileMode) {
                return this.createGeneralList();
            }
            return this.createListForSingleFile();
        }
        catch (IndexNotReadyException e) {
            return Collections.emptyList();
        }
    }

    private Collection<? extends AbstractTreeNode<?>> createListForSingleFile() {
        PsiFile psiFile = (PsiFile)this.getValue();
        TodoItem[] items = TodoFileNode.findAllTodos(psiFile, this.myBuilder.getTodoTreeStructure().getSearchHelper());
        ArrayList<TodoItemNode> children2 = new ArrayList<TodoItemNode>(items.length);
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
        if (document != null) {
            for (TodoItem todoItem : items) {
                if (todoItem.getTextRange().getEndOffset() >= document.getTextLength() + 1) continue;
                SmartTodoItemPointer pointer = new SmartTodoItemPointer(todoItem, document);
                TodoFilter toDoFilter = this.getToDoFilter();
                if (toDoFilter != null) {
                    TodoItemNode itemNode = new TodoItemNode(this.getProject(), pointer, this.myBuilder);
                    if (!toDoFilter.contains(todoItem.getPattern())) continue;
                    children2.add(itemNode);
                    continue;
                }
                children2.add(new TodoItemNode(this.getProject(), pointer, this.myBuilder));
            }
        }
        children2.sort(SmartTodoItemPointerComparator.ourInstance);
        return children2;
    }

    public static TodoItem[] findAllTodos(final PsiFile psiFile, final PsiTodoSearchHelper helper) {
        final ArrayList<TodoItem> todoItems = new ArrayList<TodoItem>(Arrays.asList(helper.findTodoItems(psiFile)));
        psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 instanceof PsiLanguageInjectionHost) {
                    InjectedLanguageManager.getInstance((Project)psiFile.getProject()).enumerate(element2, (injectedPsi, places) -> {
                        if (places.size() == 1) {
                            Document document = PsiDocumentManager.getInstance((Project)injectedPsi.getProject()).getCachedDocument(injectedPsi);
                            if (!(document instanceof DocumentWindow)) {
                                return;
                            }
                            for (TodoItem item : helper.findTodoItems(injectedPsi)) {
                                TextRange rangeInHost = ((DocumentWindow)document).injectedToHost(item.getTextRange());
                                List additionalRanges = ContainerUtil.map((Collection)item.getAdditionalTextRanges(), arg_0 -> ((DocumentWindow)((DocumentWindow)document)).injectedToHost(arg_0));
                                TodoItemImpl hostItem = new TodoItemImpl(psiFile, rangeInHost.getStartOffset(), rangeInHost.getEndOffset(), item.getPattern(), additionalRanges);
                                todoItems.add(hostItem);
                            }
                        }
                    });
                }
                super.visitElement(element2);
            }
        });
        return todoItems.toArray(new TodoItem[0]);
    }

    private Collection<? extends AbstractTreeNode<?>> createGeneralList() {
        ArrayList<TodoItemNode> children2 = new ArrayList<TodoItemNode>();
        PsiFile psiFile = (PsiFile)this.getValue();
        TodoItem[] items = TodoFileNode.findAllTodos(psiFile, this.myBuilder.getTodoTreeStructure().getSearchHelper());
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
        if (document != null) {
            for (TodoItem todoItem : items) {
                if (todoItem.getTextRange().getEndOffset() >= document.getTextLength() + 1) continue;
                SmartTodoItemPointer pointer = new SmartTodoItemPointer(todoItem, document);
                TodoFilter todoFilter = this.getToDoFilter();
                if (todoFilter != null) {
                    if (!todoFilter.contains(todoItem.getPattern())) continue;
                    children2.add(new TodoItemNode(this.getProject(), pointer, this.myBuilder));
                    continue;
                }
                children2.add(new TodoItemNode(this.getProject(), pointer, this.myBuilder));
            }
        }
        children2.sort(SmartTodoItemPointerComparator.ourInstance);
        return children2;
    }

    private TodoFilter getToDoFilter() {
        return this.myBuilder.getTodoTreeStructure().getTodoFilter();
    }

    @Override
    protected void updateImpl(@NotNull PresentationData data2) {
        int todoItemCount;
        super.updateImpl(data2);
        String newName = this.myBuilder.getTodoTreeStructure().isPackagesShown() ? ((PsiFile)this.getValue()).getName() : (this.mySingleFileMode ? ((PsiFile)this.getValue()).getName() : ((PsiFile)this.getValue()).getVirtualFile().getPresentableUrl());
        data2.setPresentableText(newName);
        try {
            todoItemCount = this.myBuilder.getTodoTreeStructure().getTodoItemCount((PsiFile)this.getValue());
        }
        catch (IndexNotReadyException e) {
            return;
        }
        if (todoItemCount > 0) {
            data2.setLocationString(IdeBundle.message((String)"node.todo.items", (Object[])new Object[]{todoItemCount}));
        }
    }

    @Override
    public int getWeight() {
        return 4;
    }
}

