/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchesNamedScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ScratchesSearchScope
extends GlobalSearchScope {
    private static final NotNullLazyKey<GlobalSearchScope, Project> SCRATCHES_SCOPE_KEY = NotNullLazyKey.create((String)"SCRATCHES_SCOPE_KEY", project -> new ScratchesSearchScope((Project)project));

    @NotNull
    public static GlobalSearchScope getScratchesScope(@NotNull Project project) {
        return (GlobalSearchScope)SCRATCHES_SCOPE_KEY.getValue((UserDataHolder)project);
    }

    private ScratchesSearchScope(@NotNull Project project) {
        super(project);
    }

    @NotNull
    public String getDisplayName() {
        return ScratchesNamedScope.scratchesAndConsoles();
    }

    public boolean contains(@NotNull VirtualFile file2) {
        return ScratchesNamedScope.contains(Objects.requireNonNull(this.getProject()), file2);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return false;
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

