/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ProjectViewUnloadedModuleNode
extends ProjectViewNode<UnloadedModuleDescription> {
    public ProjectViewUnloadedModuleNode(Project project, @NotNull UnloadedModuleDescription value2, ViewSettings viewSettings) {
        super(project, (Object)value2, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        UnloadedModuleDescription module = (UnloadedModuleDescription)this.getValue();
        if (module == null) {
            return Collections.emptyList();
        }
        List<VirtualFile> contentRoots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelUnloadedModuleRoots(module, this.getSettings());
        return ProjectViewDirectoryHelper.getInstance(this.myProject).createFileAndDirectoryNodes(contentRoots, this.getSettings());
    }

    public int getWeight() {
        return 10;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 2;
    }

    public void update(@NotNull PresentationData presentation2) {
        UnloadedModuleDescription module = (UnloadedModuleDescription)this.getValue();
        if (module == null) {
            this.setValue(null);
            return;
        }
        presentation2.setPresentableText(module.getName());
        presentation2.addText(module.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        presentation2.setIcon(AllIcons.Modules.UnloadedModule);
        presentation2.setTooltip("Unloaded module");
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        UnloadedModuleDescription module = (UnloadedModuleDescription)this.getValue();
        return module != null ? (Collection)module.getContentRoots().stream().map(VirtualFilePointer::getFile).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
    }

    public boolean contains(@NotNull VirtualFile file2) {
        UnloadedModuleDescription module = (UnloadedModuleDescription)this.getValue();
        return module != null && module.getContentRoots().stream().map(VirtualFilePointer::getFile).anyMatch(root -> root != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false));
    }
}

