/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.projectView.impl.nodes.DropTargetNode;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ProjectViewDropTarget
implements DnDNativeTarget {
    private final JTree myTree;
    private final Project myProject;

    ProjectViewDropTarget(JTree tree, Project project) {
        this.myTree = tree;
        this.myProject = project;
    }

    public boolean update(DnDEvent event) {
        event.setDropPossible(false, "");
        Point point = event.getPoint();
        if (point == null) {
            return false;
        }
        TreePath target2 = this.myTree.getClosestPathForLocation(point.x, point.y);
        if (target2 == null) {
            return false;
        }
        Rectangle bounds2 = this.myTree.getPathBounds(target2);
        if (bounds2 == null || bounds2.y > point.y || point.y >= bounds2.y + bounds2.height) {
            return false;
        }
        DropHandler handler2 = this.getDropHandler(event);
        if (handler2 == null) {
            return false;
        }
        Object[] sources = ProjectViewDropTarget.getSourcePaths(event.getAttachedObject());
        if (sources != null) {
            if (ArrayUtilRt.find((Object[])sources, (Object)target2) != -1) {
                return false;
            }
            if (!handler2.isValidSource((TreePath[])sources, target2)) {
                return false;
            }
            if (Stream.of(sources).allMatch(source -> handler2.isDropRedundant((TreePath)source, target2))) {
                return false;
            }
        } else {
            if (!FileCopyPasteUtil.isFileListFlavorAvailable(event)) {
                return false;
            }
            if (!SystemInfo.isMac) {
                PsiFileSystemItem[] psiFiles = this.getPsiFiles(FileCopyPasteUtil.getFileListFromAttachedObject(event.getAttachedObject()));
                if (psiFiles == null || psiFiles.length == 0) {
                    return false;
                }
                if (!MoveHandler.isValidTarget(this.getPsiElement(target2), (PsiElement[])psiFiles)) {
                    return false;
                }
            }
        }
        event.setHighlighting(new RelativeRectangle((Component)this.myTree, bounds2), 1);
        event.setDropPossible(true);
        return false;
    }

    public void drop(DnDEvent event) {
        Point point = event.getPoint();
        if (point == null) {
            return;
        }
        TreePath target2 = this.myTree.getClosestPathForLocation(point.x, point.y);
        if (target2 == null) {
            return;
        }
        Rectangle bounds2 = this.myTree.getPathBounds(target2);
        if (bounds2 == null || bounds2.y > point.y || point.y >= bounds2.y + bounds2.height) {
            return;
        }
        DropHandler handler2 = this.getDropHandler(event);
        if (handler2 == null) {
            return;
        }
        Object attached = event.getAttachedObject();
        TreePath[] sources = ProjectViewDropTarget.getSourcePaths(event.getAttachedObject());
        if (sources == null) {
            List<File> fileList;
            if (FileCopyPasteUtil.isFileListFlavorAvailable(event) && !(fileList = FileCopyPasteUtil.getFileListFromAttachedObject(attached)).isEmpty()) {
                handler2.doDropFiles(fileList, target2);
            }
        } else {
            ProjectViewDropTarget.doValidDrop(sources, target2, handler2);
        }
    }

    private static TreePath @Nullable [] getSourcePaths(Object transferData) {
        TransferableWrapper wrapper2 = transferData instanceof TransferableWrapper ? (TransferableWrapper)transferData : null;
        return wrapper2 == null ? null : wrapper2.getTreePaths();
    }

    private static void doValidDrop(TreePath @NotNull [] sources, @NotNull TreePath target2, @NotNull DropHandler handler2) {
        if ((target2 = ProjectViewDropTarget.getValidTarget(sources, target2, handler2)) != null && (sources = ProjectViewDropTarget.removeRedundant(sources, target2, handler2)).length != 0) {
            handler2.doDrop(sources, target2);
        }
    }

    @Nullable
    private static TreePath getValidTarget(TreePath @NotNull [] sources, @NotNull TreePath target2, @NotNull DropHandler handler2) {
        while (target2 != null) {
            if (handler2.isValidTarget(sources, target2)) {
                return target2;
            }
            if (!handler2.shouldDelegateToParent(sources, target2)) break;
            target2 = target2.getParentPath();
        }
        return null;
    }

    private static TreePath @NotNull [] removeRedundant(TreePath @NotNull [] sources, @NotNull TreePath target2, @NotNull DropHandler dropHandler) {
        return (TreePath[])Stream.of(sources).filter(source -> !dropHandler.isDropRedundant((TreePath)source, target2)).toArray(TreePath[]::new);
    }

    private DropHandler getDropHandler(DnDEvent event) {
        if (event == null) {
            return null;
        }
        DnDAction action2 = event.getAction();
        if (action2 == null) {
            return null;
        }
        int id2 = action2.getActionId();
        if (id2 == 1) {
            return new CopyDropHandler();
        }
        if (id2 != 3 && id2 != 2) {
            return null;
        }
        return new MoveDropHandler();
    }

    @Nullable
    abstract PsiElement getPsiElement(@NotNull TreePath var1);

    @Nullable
    abstract Module getModule(@NotNull PsiElement var1);

    protected PsiFileSystemItem @Nullable [] getPsiFiles(@Nullable List<? extends File> fileList) {
        if (fileList == null) {
            return null;
        }
        ArrayList<PsiFileSystemItem> sourceFiles = new ArrayList<PsiFileSystemItem>();
        for (File file2 : fileList) {
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
            PsiFileSystemItem psiFile = PsiUtilCore.findFileSystemItem((Project)this.myProject, (VirtualFile)vFile);
            if (psiFile == null) continue;
            sourceFiles.add(psiFile);
        }
        return sourceFiles.toArray(new PsiFileSystemItem[0]);
    }

    private class CopyDropHandler
    extends MoveCopyDropHandler {
        private CopyDropHandler() {
        }

        @Override
        protected boolean canDrop(TreePath @NotNull [] sources, @NotNull TreePath target2) {
            PsiElement[] sourceElements = this.getPsiElements(sources);
            PsiElement targetElement = ProjectViewDropTarget.this.getPsiElement(target2);
            if (targetElement == null) {
                return false;
            }
            PsiFile containingFile = targetElement.getContainingFile();
            boolean isTargetAcceptable = targetElement instanceof PsiDirectoryContainer || targetElement instanceof PsiDirectory || containingFile != null && containingFile.getContainingDirectory() != null;
            return isTargetAcceptable && CopyHandler.canCopy(sourceElements);
        }

        @Override
        public void doDrop(TreePath @NotNull [] sources, @NotNull TreePath target2) {
            PsiElement[] sourceElements = this.getPsiElements(sources);
            this.doDrop(target2, sourceElements);
        }

        private void doDrop(@NotNull TreePath target2, PsiElement[] sources) {
            PsiDirectory psiDirectory;
            PsiElement targetElement = ProjectViewDropTarget.this.getPsiElement(target2);
            if (targetElement == null) {
                return;
            }
            if (DumbService.isDumb((Project)ProjectViewDropTarget.this.myProject)) {
                Messages.showMessageDialog((Project)ProjectViewDropTarget.this.myProject, (String)LangBundle.message((String)"dialog.message.copy.refactoring.available.while.indexing.in.progress", (Object[])new Object[0]), (String)LangBundle.message((String)"dialog.title.indexing", (Object[])new Object[0]), null);
                return;
            }
            if (targetElement instanceof PsiDirectoryContainer) {
                PsiDirectoryContainer directoryContainer = (PsiDirectoryContainer)targetElement;
                PsiDirectory[] psiDirectories = directoryContainer.getDirectories();
                psiDirectory = psiDirectories.length != 0 ? psiDirectories[0] : null;
            } else if (targetElement instanceof PsiDirectory) {
                psiDirectory = (PsiDirectory)targetElement;
            } else {
                PsiFile containingFile = targetElement.getContainingFile();
                DnDNativeTarget.LOG.assertTrue(containingFile != null, (Object)targetElement);
                psiDirectory = containingFile.getContainingDirectory();
            }
            CopyHandler.doCopy(sources, psiDirectory);
        }

        @Override
        public boolean isDropRedundant(@NotNull TreePath source, @NotNull TreePath target2) {
            return false;
        }

        @Override
        public boolean shouldDelegateToParent(TreePath @NotNull [] sources, @NotNull TreePath target2) {
            PsiElement psiElement = ProjectViewDropTarget.this.getPsiElement(target2);
            return !(psiElement instanceof PsiDirectoryContainer) && !(psiElement instanceof PsiDirectory);
        }

        @Override
        public void doDropFiles(List<? extends File> files2, @NotNull TreePath target2) {
            PsiFileSystemItem[] sourceFileArray = ProjectViewDropTarget.this.getPsiFiles(files2);
            this.doDrop(target2, (PsiElement[])sourceFileArray);
        }
    }

    private class MoveDropHandler
    extends MoveCopyDropHandler {
        private MoveDropHandler() {
        }

        @Override
        protected boolean canDrop(TreePath @NotNull [] sources, @NotNull TreePath target2) {
            DropTargetNode node = (DropTargetNode)TreeUtil.getLastUserObject(DropTargetNode.class, (TreePath)target2);
            if (node != null && node.canDrop(sources)) {
                return true;
            }
            PsiElement[] sourceElements = this.getPsiElements(sources);
            PsiElement targetElement = ProjectViewDropTarget.this.getPsiElement(target2);
            return sourceElements.length == 0 || targetElement != null && MoveHandler.canMove(sourceElements, targetElement);
        }

        @Override
        public void doDrop(TreePath @NotNull [] sources, @NotNull TreePath target2) {
            DropTargetNode node = (DropTargetNode)TreeUtil.getLastUserObject(DropTargetNode.class, (TreePath)target2);
            if (node != null && node.canDrop(sources)) {
                node.drop(sources, DataManager.getInstance().getDataContext((Component)ProjectViewDropTarget.this.myTree));
            } else {
                this.doDrop(ProjectViewDropTarget.this.getPsiElement(target2), this.getPsiElements(sources), false);
            }
        }

        private void doDrop(PsiElement target2, PsiElement[] sources, boolean externalDrop) {
            if (target2 == null) {
                return;
            }
            if (DumbService.isDumb((Project)ProjectViewDropTarget.this.myProject)) {
                Messages.showMessageDialog((Project)ProjectViewDropTarget.this.myProject, (String)LangBundle.message((String)"dialog.message.move.refactoring.available.while.indexing.in.progress", (Object[])new Object[0]), (String)LangBundle.message((String)"dialog.title.indexing", (Object[])new Object[0]), null);
                return;
            }
            if (!ProjectViewDropTarget.this.myProject.isInitialized()) {
                Messages.showMessageDialog((Project)ProjectViewDropTarget.this.myProject, (String)LangBundle.message((String)"dialog.message.move.refactoring.available", (Object[])new Object[0]), (String)LangBundle.message((String)"dialog.title.project.initialization", (Object[])new Object[0]), null);
                return;
            }
            Module module = ProjectViewDropTarget.this.getModule(target2);
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)ProjectViewDropTarget.this.myTree);
            PsiDocumentManager.getInstance((Project)ProjectViewDropTarget.this.myProject).commitAllDocuments();
            if (!target2.isValid()) {
                return;
            }
            for (PsiElement element2 : sources) {
                if (element2.isValid()) continue;
                return;
            }
            DataContext context = dataId -> {
                if (LangDataKeys.TARGET_MODULE.is(dataId) && module != null) {
                    return module;
                }
                if (LangDataKeys.TARGET_PSI_ELEMENT.is(dataId)) {
                    return target2;
                }
                return externalDrop ? null : dataContext.getData(dataId);
            };
            this.getActionHandler().invoke(ProjectViewDropTarget.this.myProject, sources, context);
        }

        private RefactoringActionHandler getActionHandler() {
            return RefactoringActionHandlerFactory.getInstance().createMoveHandler();
        }

        @Override
        public boolean isDropRedundant(@NotNull TreePath source, @NotNull TreePath target2) {
            return target2.equals(source.getParentPath()) || MoveHandler.isMoveRedundant(ProjectViewDropTarget.this.getPsiElement(source), ProjectViewDropTarget.this.getPsiElement(target2));
        }

        @Override
        public boolean shouldDelegateToParent(TreePath @NotNull [] sources, @NotNull TreePath target2) {
            PsiElement psiElement = ProjectViewDropTarget.this.getPsiElement(target2);
            return !MoveHandler.isValidTarget(psiElement, this.getPsiElements(sources));
        }

        @Override
        public void doDropFiles(List<? extends File> files2, @NotNull TreePath target2) {
            PsiFileSystemItem[] sourceFileArray = ProjectViewDropTarget.this.getPsiFiles(files2);
            DropTargetNode node = (DropTargetNode)TreeUtil.getLastUserObject(DropTargetNode.class, (TreePath)target2);
            if (node != null) {
                node.dropExternalFiles(sourceFileArray, DataManager.getInstance().getDataContext((Component)ProjectViewDropTarget.this.myTree));
            } else {
                this.doDrop(ProjectViewDropTarget.this.getPsiElement(target2), (PsiElement[])sourceFileArray, true);
            }
        }
    }

    abstract class MoveCopyDropHandler
    implements DropHandler {
        MoveCopyDropHandler() {
        }

        @Override
        public boolean isValidSource(TreePath @NotNull [] sources, @NotNull TreePath target2) {
            return this.canDrop(sources, target2);
        }

        @Override
        public boolean isValidTarget(TreePath @NotNull [] sources, @NotNull TreePath target2) {
            return this.canDrop(sources, target2);
        }

        protected abstract boolean canDrop(TreePath @NotNull [] var1, @NotNull TreePath var2);

        protected PsiElement @NotNull [] getPsiElements(TreePath @NotNull [] paths) {
            ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>(paths.length);
            for (TreePath path : paths) {
                PsiElement psiElement = ProjectViewDropTarget.this.getPsiElement(path);
                if (psiElement == null) continue;
                psiElements.add(psiElement);
            }
            if (!psiElements.isEmpty()) {
                return PsiUtilCore.toPsiElementArray(psiElements);
            }
            return BaseRefactoringAction.getPsiElementArray(DataManager.getInstance().getDataContext((Component)ProjectViewDropTarget.this.myTree));
        }
    }

    private static interface DropHandler {
        public boolean isValidSource(TreePath @NotNull [] var1, @NotNull TreePath var2);

        public boolean isValidTarget(TreePath @NotNull [] var1, @NotNull TreePath var2);

        public boolean shouldDelegateToParent(TreePath @NotNull [] var1, @NotNull TreePath var2);

        public boolean isDropRedundant(@NotNull TreePath var1, @NotNull TreePath var2);

        public void doDrop(TreePath @NotNull [] var1, @NotNull TreePath var2);

        public void doDropFiles(List<? extends File> var1, @NotNull TreePath var2);
    }
}

