/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectViewDeleteElementProvider
implements DeleteProvider {
    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        PsiElement[] elements2 = this.getElementsToDelete(project, dataContext);
        return DeleteHandler.shouldEnableDeleteAction(elements2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteElement(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        ArrayList<PsiElement> validElements = new ArrayList<PsiElement>();
        for (PsiElement psiElement : this.getElementsToDelete(project, dataContext)) {
            if (psiElement == null || !psiElement.isValid()) continue;
            validElements.add(psiElement);
        }
        PsiElement[] elements2 = PsiUtilCore.toPsiElementArray(validElements);
        LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
        try {
            DeleteHandler.deletePsiElement(elements2, project);
        }
        finally {
            a.finish();
        }
    }

    protected abstract PsiElement @NotNull [] getSelectedPSIElements(@NotNull DataContext var1);

    protected abstract Boolean hideEmptyMiddlePackages(@NotNull DataContext var1);

    private PsiElement @NotNull [] getElementsToDelete(@NotNull Project project, @NotNull DataContext dataContext) {
        PsiElement[] elements2 = this.getSelectedPSIElements(dataContext);
        for (int idx = 0; idx < elements2.length; ++idx) {
            PsiFile psiFile;
            VirtualFile vFile;
            VirtualFile virtualFile;
            String path;
            PsiElement element2 = elements2[idx];
            if (!(element2 instanceof PsiDirectory)) continue;
            PsiDirectory directory = (PsiDirectory)element2;
            ProjectViewDirectoryHelper directoryHelper = ProjectViewDirectoryHelper.getInstance(project);
            if (this.hideEmptyMiddlePackages(dataContext).booleanValue() && directory.getChildren().length == 0 && !directoryHelper.skipDirectory(directory)) {
                PsiElement[] children2;
                PsiDirectory parent;
                while ((parent = directory.getParentDirectory()) != null && !directoryHelper.skipDirectory(parent) && !PsiDirectoryFactory.getInstance(project).getQualifiedName(parent, false).isEmpty() && ((children2 = parent.getChildren()).length == 0 || children2.length == 1 && children2[0] == directory)) {
                    directory = parent;
                }
                elements2[idx] = directory;
            }
            if (!(path = (virtualFile = directory.getVirtualFile()).getPath()).endsWith("!/") || (vFile = LocalFileSystem.getInstance().findFileByPath(path.substring(0, path.length() - "!/".length()))) == null || (psiFile = PsiManager.getInstance((Project)project).findFile(vFile)) == null) continue;
            elements2[idx] = psiFile;
        }
        return elements2;
    }
}

