/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.impl.FlattenModulesToggleAction;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.RootsProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.impl.AsyncProjectViewSupport;
import com.intellij.ide.projectView.impl.GroupByTypeComparator;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectViewDropTarget;
import com.intellij.ide.projectView.impl.ProjectViewFileVisitor;
import com.intellij.ide.projectView.impl.ProjectViewNodeVisitor;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.ModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.problems.ProblemListener;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class AbstractProjectViewPane
implements DataProvider,
Disposable,
BusyObject {
    private static final Logger LOG = Logger.getInstance(AbstractProjectViewPane.class);
    public static final ProjectExtensionPointName<AbstractProjectViewPane> EP = new ProjectExtensionPointName("com.intellij.projectViewPane");
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.2")
    public static final ExtensionPointName<AbstractProjectViewPane> EP_NAME = ExtensionPointName.create((String)"com.intellij.projectViewPane");
    @NotNull
    protected final Project myProject;
    protected DnDAwareTree myTree;
    protected AbstractTreeStructure myTreeStructure;
    private AbstractTreeBuilder myTreeBuilder;
    private final Map<String, TreeState> myReadTreeState = new HashMap<String, TreeState>();
    private final AtomicBoolean myTreeStateRestored = new AtomicBoolean();
    private String mySubId;
    @NonNls
    private static final String ELEMENT_SUB_PANE = "subPane";
    @NonNls
    private static final String ATTRIBUTE_SUB_ID = "subId";
    private DnDTarget myDropTarget;
    private DnDSource myDragSource;

    private void queueUpdateByProblem() {
        if (Registry.is((String)"projectView.showHierarchyErrors") && this.myTreeBuilder != null) {
            this.myTreeBuilder.queueUpdate();
        }
    }

    protected AbstractProjectViewPane(@NotNull Project project) {
        this.myProject = project;
        ProblemListener problemListener = new ProblemListener(){

            public void problemsAppeared(@NotNull VirtualFile file2) {
                AbstractProjectViewPane.this.queueUpdateByProblem();
            }

            public void problemsChanged(@NotNull VirtualFile file2) {
                AbstractProjectViewPane.this.queueUpdateByProblem();
            }

            public void problemsDisappeared(@NotNull VirtualFile file2) {
                AbstractProjectViewPane.this.queueUpdateByProblem();
            }
        };
        project.getMessageBus().connect((Disposable)this).subscribe(ProblemListener.TOPIC, (Object)problemListener);
        Disposer.register((Disposable)project, (Disposable)this);
        TreeStructureProvider.EP.addExtensionPointListener((AreaInstance)project, (ExtensionPointListener)new ExtensionPointListener<TreeStructureProvider>(){

            public void extensionAdded(@NotNull TreeStructureProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                AbstractProjectViewPane.this.rebuildCompletely(false);
            }

            public void extensionRemoved(@NotNull TreeStructureProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                AbstractProjectViewPane.this.rebuildCompletely(true);
            }
        }, (Disposable)this);
        ProjectViewNodeDecorator.EP.addExtensionPointListener((AreaInstance)project, (ExtensionPointListener)new ExtensionPointListener<ProjectViewNodeDecorator>(){

            public void extensionAdded(@NotNull ProjectViewNodeDecorator extension, @NotNull PluginDescriptor pluginDescriptor) {
                AbstractProjectViewPane.this.rebuildCompletely(false);
            }

            public void extensionRemoved(@NotNull ProjectViewNodeDecorator extension, @NotNull PluginDescriptor pluginDescriptor) {
                AbstractProjectViewPane.this.rebuildCompletely(true);
            }
        }, (Disposable)this);
    }

    private void rebuildCompletely(boolean wait) {
        ActionCallback callback2 = this.updateFromRoot(true);
        if (wait) {
            callback2.waitFor(5000L);
        }
        this.myReadTreeState.clear();
        JTree tree = this.getTree();
        if (tree != null) {
            tree.clearSelection();
            tree.setAnchorSelectionPath(null);
            tree.setLeadSelectionPath(null);
        }
    }

    @Deprecated
    protected final void fireTreeChangeListener() {
    }

    @NotNull
    public abstract String getTitle();

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public abstract String getId();

    public boolean isDefaultPane(@NotNull Project project) {
        return false;
    }

    @Nullable
    public final String getSubId() {
        return this.mySubId;
    }

    public final void setSubId(@Nullable String subId) {
        if (Comparing.strEqual((String)this.mySubId, (String)subId)) {
            return;
        }
        this.saveExpandedPaths();
        this.mySubId = subId;
        this.onSubIdChange();
    }

    protected void onSubIdChange() {
    }

    public boolean isInitiallyVisible() {
        return true;
    }

    public boolean supportsManualOrder() {
        return false;
    }

    @NotNull
    protected String getManualOrderOptionText() {
        return IdeBundle.message((String)"action.manual.order", (Object[])new Object[0]);
    }

    public String @NotNull [] getSubIds() {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public String getPresentableSubIdName(@NotNull String subId) {
        throw new IllegalStateException("should not call");
    }

    @NotNull
    public Icon getPresentableSubIdIcon(@NotNull String subId) {
        return this.getIcon();
    }

    @NotNull
    public abstract JComponent createComponent();

    public JComponent getComponentToFocus() {
        return this.myTree;
    }

    public void expand(Object @Nullable [] path, boolean requestFocus) {
        DefaultMutableTreeNode node;
        if (this.getTreeBuilder() == null || path == null) {
            return;
        }
        AbstractTreeUi ui = this.getTreeBuilder().getUi();
        if (ui != null) {
            ui.buildNodeForPath(path);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = node = ui == null ? null : ui.getNodeForPath(path);
        if (node == null) {
            return;
        }
        TreePath treePath = new TreePath(node.getPath());
        this.myTree.expandPath(treePath);
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myTree), true));
        }
        TreeUtil.selectPath((JTree)((Object)this.myTree), (TreePath)treePath);
    }

    public void dispose() {
        if (this.myDropTarget != null) {
            DnDManager.getInstance().unregisterTarget(this.myDropTarget, (JComponent)((Object)this.myTree));
            this.myDropTarget = null;
        }
        if (this.myDragSource != null) {
            DnDManager.getInstance().unregisterSource(this.myDragSource, (JComponent)((Object)this.myTree));
            this.myDragSource = null;
        }
        this.setTreeBuilder(null);
        this.myTree = null;
        this.myTreeStructure = null;
    }

    @NotNull
    public abstract ActionCallback updateFromRoot(boolean var1);

    public void updateFrom(Object element2, boolean forceResort, boolean updateStructure) {
        AsyncProjectViewSupport support;
        AbstractTreeBuilder builder2 = this.getTreeBuilder();
        if (builder2 != null) {
            builder2.queueUpdateFrom(element2, forceResort, updateStructure);
        } else if (element2 instanceof PsiElement && (support = this.getAsyncSupport()) != null) {
            support.updateByElement((PsiElement)element2, updateStructure);
        }
    }

    public abstract void select(Object var1, VirtualFile var2, boolean var3);

    public void selectModule(@NotNull Module module, boolean requestFocus) {
        this.doSelectModuleOrGroup(module, requestFocus);
    }

    private void doSelectModuleOrGroup(@NotNull Object toSelect2, boolean requestFocus) {
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)this.myProject);
        Runnable runnable2 = () -> {
            BaseProjectTreeBuilder builder2;
            ProjectView projectView;
            if (requestFocus && (projectView = ProjectView.getInstance(this.myProject)) != null) {
                projectView.changeView(this.getId(), this.getSubId());
            }
            if ((builder2 = (BaseProjectTreeBuilder)this.getTreeBuilder()) != null) {
                builder2.selectInWidth(toSelect2, requestFocus, node -> node instanceof AbstractModuleNode || node instanceof ModuleGroupNode || node instanceof AbstractProjectNode);
            }
        };
        if (requestFocus) {
            windowManager.getToolWindow("Project").activate(runnable2);
        } else {
            runnable2.run();
        }
    }

    public void selectModuleGroup(@NotNull ModuleGroup moduleGroup, boolean requestFocus) {
        this.doSelectModuleOrGroup(moduleGroup, requestFocus);
    }

    public TreePath[] getSelectionPaths() {
        return this.myTree == null ? null : this.myTree.getSelectionPaths();
    }

    public void addToolbarActions(@NotNull DefaultActionGroup actionGroup) {
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    protected ToggleAction createFlattenModulesAction(@NotNull BooleanSupplier isApplicable) {
        return new FlattenModulesToggleAction(this.myProject, () -> isApplicable.getAsBoolean() && ProjectView.getInstance(this.myProject).isShowModules(this.getId()), () -> ProjectView.getInstance(this.myProject).isFlattenModules(this.getId()), value2 -> ProjectView.getInstance(this.myProject).setFlattenModules(this.getId(), (boolean)value2));
    }

    @NotNull
    protected <T extends NodeDescriptor<?>> List<T> getSelectedNodes(@NotNull Class<T> nodeClass) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return Collections.emptyList();
        }
        ArrayList<NodeDescriptor> result2 = new ArrayList<NodeDescriptor>();
        for (TreePath path : paths) {
            NodeDescriptor userObject = (NodeDescriptor)TreeUtil.getLastUserObject(nodeClass, (TreePath)path);
            if (userObject == null) continue;
            result2.add(userObject);
        }
        return result2;
    }

    public boolean isAutoScrollEnabledFor(@NotNull VirtualFile file2) {
        return true;
    }

    public Object getData(@NotNull String dataId) {
        List<AbstractTreeNode<?>> nodes;
        Object data2;
        if (this.myTreeStructure instanceof AbstractTreeStructureBase && (data2 = ((AbstractTreeStructureBase)this.myTreeStructure).getDataFromProviders(nodes = this.getSelectedNodes(AbstractTreeNode.class), dataId)) != null) {
            return data2;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null) {
                return null;
            }
            ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
            for (TreePath path : paths) {
                Object node = path.getLastPathComponent();
                Object userObject = TreeUtil.getUserObject((Object)node);
                if (userObject instanceof Navigatable) {
                    navigatables.add((Navigatable)userObject);
                    continue;
                }
                if (!(node instanceof Navigatable)) continue;
                navigatables.add((Navigatable)node);
            }
            return navigatables.isEmpty() ? null : navigatables.toArray(new Navigatable[0]);
        }
        return null;
    }

    public abstract int getWeight();

    @NotNull
    public abstract SelectInTarget createSelectInTarget();

    public final TreePath getSelectedPath() {
        return this.myTree == null ? null : TreeUtil.getSelectedPathIfOne((JTree)((Object)this.myTree));
    }

    public final NodeDescriptor getSelectedDescriptor() {
        return (NodeDescriptor)TreeUtil.getLastUserObject(NodeDescriptor.class, (TreePath)this.getSelectedPath());
    }

    @Deprecated
    public final DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this.getSelectedPath();
        return path == null ? null : (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), DefaultMutableTreeNode.class);
    }

    public final Object getSelectedElement() {
        Object[] elements2 = this.getSelectedElements();
        return elements2.length == 1 ? elements2[0] : null;
    }

    public final PsiElement @NotNull [] getSelectedPSIElements() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (TreePath path : paths) {
            result2.addAll(this.getElementsFromNode(path.getLastPathComponent()));
        }
        return PsiUtilCore.toPsiElementArray(result2);
    }

    @NotNull
    public List<PsiElement> getElementsFromNode(@Nullable Object node) {
        Object value2 = this.getValueFromNode(node);
        JBIterable it = value2 instanceof PsiElement || value2 instanceof VirtualFile ? JBIterable.of((Object)value2) : (value2 instanceof Object[] ? JBIterable.of((Object[])((Object[])value2)) : (value2 instanceof Iterable ? JBIterable.from((Iterable)((Iterable)value2)) : JBIterable.of((Object)TreeUtil.getUserObject((Object)node))));
        return it.flatten(o -> o instanceof RootsProvider ? ((RootsProvider)o).getRoots() : Collections.singleton(o)).map(o -> o instanceof VirtualFile ? PsiUtilCore.findFileSystemItem((Project)this.myProject, (VirtualFile)((VirtualFile)o)) : o).filter(PsiElement.class).filter(PsiElement::isValid).toList();
    }

    @Deprecated
    @Nullable
    public PsiElement getPSIElementFromNode(@Nullable TreeNode node) {
        return (PsiElement)ContainerUtil.getFirstItem(this.getElementsFromNode(node));
    }

    @Nullable
    protected Module getNodeModule(@Nullable Object element2) {
        if (element2 instanceof PsiElement) {
            PsiElement psiElement = (PsiElement)element2;
            return ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        }
        return null;
    }

    public final Object @NotNull [] getSelectedElements() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<Object> list2 = new ArrayList<Object>(paths.length);
        for (TreePath path : paths) {
            Object lastPathComponent = path.getLastPathComponent();
            Object element2 = this.getValueFromNode(lastPathComponent);
            if (element2 instanceof Object[]) {
                Collections.addAll(list2, (Object[])element2);
                continue;
            }
            if (element2 == null) continue;
            list2.add(element2);
        }
        return ArrayUtil.toObjectArray(list2);
    }

    @Nullable
    public Object getValueFromNode(@Nullable Object node) {
        return AbstractProjectViewPane.extractValueFromNode(node);
    }

    @Deprecated
    protected Object exhumeElementFromNode(DefaultMutableTreeNode node) {
        return this.getValueFromNode(node);
    }

    @Nullable
    public static Object extractValueFromNode(@Nullable Object node) {
        Object userObject = TreeUtil.getUserObject((Object)node);
        Object element2 = null;
        if (userObject instanceof AbstractTreeNode) {
            AbstractTreeNode descriptor2 = (AbstractTreeNode)userObject;
            element2 = descriptor2.getValue();
        } else if (userObject instanceof NodeDescriptor) {
            NodeDescriptor descriptor3 = (NodeDescriptor)userObject;
            element2 = descriptor3.getElement();
            if (element2 instanceof AbstractTreeNode) {
                element2 = ((AbstractTreeNode)element2).getValue();
            }
        } else if (userObject != null) {
            element2 = userObject;
        }
        return element2;
    }

    public AbstractTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    public AbstractTreeStructure getTreeStructure() {
        return this.myTreeStructure;
    }

    public void readExternal(@NotNull Element element2) {
        List subPanes = element2.getChildren(ELEMENT_SUB_PANE);
        for (Element subPane : subPanes) {
            String subId = subPane.getAttributeValue(ATTRIBUTE_SUB_ID);
            TreeState treeState = TreeState.createFrom((Element)subPane);
            if (treeState.isEmpty()) continue;
            this.myReadTreeState.put(subId, treeState);
        }
    }

    public void writeExternal(Element element2) {
        this.saveExpandedPaths();
        for (Map.Entry<String, TreeState> entry : this.myReadTreeState.entrySet()) {
            String subId = entry.getKey();
            TreeState treeState = entry.getValue();
            Element subPane = new Element(ELEMENT_SUB_PANE);
            if (subId != null) {
                subPane.setAttribute(ATTRIBUTE_SUB_ID, subId);
            }
            treeState.writeExternal(subPane);
            element2.addContent(subPane);
        }
    }

    protected void saveExpandedPaths() {
        this.myTreeStateRestored.set(false);
        if (this.myTree != null) {
            TreeState treeState = TreeState.createOn((JTree)((Object)this.myTree));
            if (!treeState.isEmpty()) {
                this.myReadTreeState.put(this.getSubId(), treeState);
            } else {
                this.myReadTreeState.remove(this.getSubId());
            }
        }
    }

    public final void restoreExpandedPaths() {
        if (this.myTree == null || this.myTreeStateRestored.getAndSet(true)) {
            return;
        }
        TreeState treeState = this.myReadTreeState.get(this.getSubId());
        if (treeState != null && !treeState.isEmpty()) {
            treeState.applyTo((JTree)((Object)this.myTree));
        } else if (this.myTree.isSelectionEmpty()) {
            TreeUtil.promiseSelectFirst((JTree)((Object)this.myTree));
        }
    }

    @NotNull
    protected Comparator<NodeDescriptor<?>> createComparator() {
        return new GroupByTypeComparator(ProjectView.getInstance(this.myProject), this.getId());
    }

    public void installComparator() {
        this.installComparator(this.getTreeBuilder());
    }

    void installComparator(AbstractTreeBuilder treeBuilder) {
        this.installComparator(treeBuilder, this.createComparator());
    }

    public void installComparator(@NotNull Comparator<? super NodeDescriptor<?>> comparator2) {
        this.installComparator(this.getTreeBuilder(), comparator2);
    }

    protected void installComparator(AbstractTreeBuilder builder2, @NotNull Comparator<? super NodeDescriptor<?>> comparator2) {
        if (builder2 != null) {
            builder2.setNodeDescriptorComparator(comparator2);
        }
    }

    public JTree getTree() {
        return this.myTree;
    }

    public PsiDirectory @NotNull [] getSelectedDirectories() {
        ArrayList<PsiDirectory> directories = new ArrayList<PsiDirectory>();
        for (PsiDirectoryNode node : this.getSelectedNodes(PsiDirectoryNode.class)) {
            PsiDirectory directory = (PsiDirectory)node.getValue();
            if (directory == null) continue;
            directories.add(directory);
            Object parentValue = node.getParent().getValue();
            if (!(parentValue instanceof PsiDirectory) || !Registry.is((String)"projectView.choose.directory.on.compacted.middle.packages")) continue;
            while ((directory = directory.getParentDirectory()) != null && !directory.equals(parentValue)) {
                directories.add(directory);
            }
        }
        if (!directories.isEmpty()) {
            return directories.toArray(PsiDirectory.EMPTY_ARRAY);
        }
        PsiElement[] elements2 = this.getSelectedPSIElements();
        if (elements2.length == 1) {
            PsiElement element2 = elements2[0];
            if (element2 instanceof PsiDirectory) {
                return new PsiDirectory[]{(PsiDirectory)element2};
            }
            if (element2 instanceof PsiDirectoryContainer) {
                return ((PsiDirectoryContainer)element2).getDirectories();
            }
            PsiFile containingFile = element2.getContainingFile();
            if (containingFile != null) {
                PsiDirectory psiDirectory = containingFile.getContainingDirectory();
                if (psiDirectory != null) {
                    return new PsiDirectory[]{psiDirectory};
                }
                VirtualFile file2 = containingFile.getVirtualFile();
                if (file2 instanceof VirtualFileWindow) {
                    VirtualFile delegate = ((VirtualFileWindow)file2).getDelegate();
                    PsiFile delegatePsiFile = containingFile.getManager().findFile(delegate);
                    if (delegatePsiFile != null && delegatePsiFile.getContainingDirectory() != null) {
                        return new PsiDirectory[]{delegatePsiFile.getContainingDirectory()};
                    }
                }
                return PsiDirectory.EMPTY_ARRAY;
            }
        } else {
            TreePath path = this.getSelectedPath();
            if (path != null) {
                Object component2 = path.getLastPathComponent();
                if (component2 instanceof DefaultMutableTreeNode) {
                    return this.getSelectedDirectoriesInAmbiguousCase(((DefaultMutableTreeNode)component2).getUserObject());
                }
                return this.getSelectedDirectoriesInAmbiguousCase(component2);
            }
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    protected PsiDirectory @NotNull [] getSelectedDirectoriesInAmbiguousCase(Object userObject) {
        PsiDirectory directory;
        VirtualFile file2;
        if (userObject instanceof AbstractModuleNode) {
            Module module = (Module)((AbstractModuleNode)((Object)userObject)).getValue();
            if (module != null && !module.isDisposed()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                VirtualFile[] sourceRoots = moduleRootManager.getSourceRoots();
                ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>(sourceRoots.length);
                PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
                for (VirtualFile sourceRoot : sourceRoots) {
                    PsiDirectory directory2 = psiManager.findDirectory(sourceRoot);
                    if (directory2 == null) continue;
                    dirs.add(directory2);
                }
                return dirs.toArray(PsiDirectory.EMPTY_ARRAY);
            }
        } else if (userObject instanceof ProjectViewNode && (file2 = ((ProjectViewNode)userObject).getVirtualFile()) != null && file2.isValid() && file2.isDirectory() && (directory = PsiManager.getInstance((Project)this.myProject).findDirectory(file2)) != null) {
            return new PsiDirectory[]{directory};
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    public static PsiElement @Nullable [] getTransferedPsiElements(@NotNull Transferable transferable) {
        try {
            Object transferData = transferable.getTransferData(DnDEventImpl.ourDataFlavor);
            if (transferData instanceof TransferableWrapper) {
                return ((TransferableWrapper)transferData).getPsiElements();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static TreeNode @Nullable [] getTransferedTreeNodes(@NotNull Transferable transferable) {
        try {
            Object transferData = transferable.getTransferData(DnDEventImpl.ourDataFlavor);
            if (transferData instanceof TransferableWrapper) {
                return ((TransferableWrapper)transferData).getTreeNodes();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myDropTarget = new ProjectViewDropTarget((JTree)((Object)this.myTree), this.myProject){

                @Override
                @Nullable
                protected PsiElement getPsiElement(@NotNull TreePath path) {
                    return (PsiElement)ContainerUtil.getFirstItem(AbstractProjectViewPane.this.getElementsFromNode(path.getLastPathComponent()));
                }

                @Override
                @Nullable
                protected Module getModule(@NotNull PsiElement element2) {
                    return AbstractProjectViewPane.this.getNodeModule(element2);
                }

                public void cleanUpOnLeave() {
                    AbstractProjectViewPane.this.beforeDnDLeave();
                    super.cleanUpOnLeave();
                }

                @Override
                public boolean update(DnDEvent event) {
                    AbstractProjectViewPane.this.beforeDnDUpdate();
                    return super.update(event);
                }
            };
            this.myDragSource = new MyDragSource();
            DnDManager dndManager = DnDManager.getInstance();
            dndManager.registerSource(this.myDragSource, (JComponent)((Object)this.myTree));
            dndManager.registerTarget(this.myDropTarget, (JComponent)((Object)this.myTree));
        }
    }

    protected void beforeDnDUpdate() {
    }

    protected void beforeDnDLeave() {
    }

    public void setTreeBuilder(AbstractTreeBuilder treeBuilder) {
        if (treeBuilder != null) {
            Disposer.register((Disposable)this, (Disposable)treeBuilder);
        }
        this.myTreeBuilder = treeBuilder;
    }

    @ApiStatus.Internal
    public boolean supportsAbbreviatePackageNames() {
        return true;
    }

    @ApiStatus.Internal
    public boolean supportsCompactDirectories() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsFlattenModules() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsFoldersAlwaysOnTop() {
        return true;
    }

    @ApiStatus.Internal
    public boolean supportsHideEmptyMiddlePackages() {
        return true;
    }

    @ApiStatus.Internal
    public boolean supportsShowExcludedFiles() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsShowLibraryContents() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsShowModules() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsSortByType() {
        return true;
    }

    private static boolean canDragElements(Object @NotNull [] elements2, @NotNull DataContext dataContext, int dragAction) {
        for (Object element2 : elements2) {
            if (!(element2 instanceof Module)) continue;
            return true;
        }
        return dragAction == 2 && MoveHandler.canMove(dataContext);
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (this.myTreeBuilder == null) {
            return ActionCallback.DONE;
        }
        if (this.myTreeBuilder.isDisposed()) {
            return ActionCallback.REJECTED;
        }
        return this.myTreeBuilder.getUi().getReady(requestor);
    }

    @Deprecated
    @NotNull
    public Promise<TreePath> promisePathToElement(@NotNull Object element2) {
        AbstractTreeBuilder builder2 = this.getTreeBuilder();
        if (builder2 != null) {
            DefaultMutableTreeNode node = builder2.getNodeForElement(element2);
            if (node == null) {
                return Promises.rejectedPromise();
            }
            return Promises.resolvedPromise((Object)new TreePath(node.getPath()));
        }
        TreeVisitor visitor = AbstractProjectViewPane.createVisitor(element2);
        if (visitor == null || this.myTree == null) {
            return Promises.rejectedPromise();
        }
        return TreeUtil.promiseVisit((JTree)((Object)this.myTree), (TreeVisitor)visitor);
    }

    @ApiStatus.Internal
    public boolean isVisibleAndSelected(Object element2) {
        JTree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        TreePath path = TreeUtil.getSelectedPathIfOne((JTree)tree);
        if (path == null) {
            return false;
        }
        Rectangle bounds2 = tree.getPathBounds(path);
        if (bounds2 == null) {
            return false;
        }
        Rectangle visible = tree.getVisibleRect();
        if (bounds2.y < visible.y || bounds2.y > visible.y + visible.height - bounds2.height) {
            return false;
        }
        AbstractTreeNode node = (AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)path);
        return node != null && node.canRepresent(element2);
    }

    AsyncProjectViewSupport getAsyncSupport() {
        return null;
    }

    @NotNull
    static List<TreeVisitor> createVisitors(Object ... objects) {
        return StreamEx.of((Object[])objects).map(AbstractProjectViewPane::createVisitor).nonNull().toImmutableList();
    }

    @Nullable
    public static TreeVisitor createVisitor(@NotNull Object object) {
        Object node;
        if (object instanceof AbstractTreeNode) {
            node = (AbstractTreeNode)object;
            object = node.getValue();
        }
        if (object instanceof ProjectFileNode) {
            node = (ProjectFileNode)object;
            object = node.getVirtualFile();
        }
        if (object instanceof VirtualFile) {
            return AbstractProjectViewPane.createVisitor((VirtualFile)object);
        }
        if (object instanceof PsiElement) {
            return AbstractProjectViewPane.createVisitor((PsiElement)object);
        }
        LOG.warn("unsupported object: " + object);
        return null;
    }

    @NotNull
    public static TreeVisitor createVisitor(@NotNull VirtualFile file2) {
        return AbstractProjectViewPane.createVisitor(null, file2);
    }

    @Nullable
    public static TreeVisitor createVisitor(@NotNull PsiElement element2) {
        return AbstractProjectViewPane.createVisitor(element2, null);
    }

    @Nullable
    public static TreeVisitor createVisitor(@Nullable PsiElement element2, @Nullable VirtualFile file2) {
        return AbstractProjectViewPane.createVisitor(element2, file2, null);
    }

    @Nullable
    static TreeVisitor createVisitor(@Nullable PsiElement element2, @Nullable VirtualFile file2, @Nullable List<? super TreePath> collector) {
        Predicate<TreePath> predicate;
        Predicate<TreePath> predicate2 = predicate = collector == null ? null : path -> {
            collector.add((TreePath)path);
            return false;
        };
        if (element2 != null && element2.isValid()) {
            return new ProjectViewNodeVisitor(element2, file2, predicate);
        }
        if (file2 != null) {
            return new ProjectViewFileVisitor(file2, predicate);
        }
        LOG.warn(element2 != null ? "element invalidated: " + element2 : "cannot create visitor without element and/or file");
        return null;
    }

    private final class MyDragSource
    implements DnDSource {
        private MyDragSource() {
        }

        public boolean canStartDragging(DnDAction action2, Point dragOrigin) {
            if ((action2.getActionId() & 3) == 0) {
                return false;
            }
            Object[] elements2 = AbstractProjectViewPane.this.getSelectedElements();
            PsiElement[] psiElements = AbstractProjectViewPane.this.getSelectedPSIElements();
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)AbstractProjectViewPane.this.myTree));
            return psiElements.length > 0 || AbstractProjectViewPane.canDragElements(elements2, dataContext, action2.getActionId());
        }

        public DnDDragStartBean startDragging(DnDAction action2, Point dragOrigin) {
            final PsiElement[] psiElements = AbstractProjectViewPane.this.getSelectedPSIElements();
            final TreePath[] paths = AbstractProjectViewPane.this.getSelectionPaths();
            return new DnDDragStartBean((Object)new TransferableWrapper(){

                @Override
                public List<File> asFileList() {
                    return PsiCopyPasteManager.asFileList(psiElements);
                }

                @Override
                public TreePath @Nullable [] getTreePaths() {
                    return paths;
                }

                @Override
                public TreeNode[] getTreeNodes() {
                    return TreePathUtil.toTreeNodes(this.getTreePaths());
                }

                @Override
                public PsiElement[] getPsiElements() {
                    return psiElements;
                }
            });
        }

        @Nullable
        public Pair<Image, Point> createDraggedImage(DnDAction action2, Point dragOrigin, @NotNull DnDDragStartBean bean) {
            TreePath[] paths = AbstractProjectViewPane.this.getSelectionPaths();
            if (paths == null) {
                return null;
            }
            int count = paths.length;
            JLabel label2 = new JLabel(count + " " + StringUtil.pluralize((String)"item", (int)count));
            label2.setOpaque(true);
            label2.setForeground(RenderingUtil.getForeground((JTree)((Object)AbstractProjectViewPane.this.myTree)));
            label2.setBackground(RenderingUtil.getBackground((JTree)((Object)AbstractProjectViewPane.this.myTree)));
            label2.setFont(AbstractProjectViewPane.this.myTree.getFont());
            label2.setSize(label2.getPreferredSize());
            BufferedImage image = ImageUtil.createImage((int)label2.getWidth(), (int)label2.getHeight(), (int)2);
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
            label2.paint(g2);
            g2.dispose();
            return new Pair((Object)image, (Object)new Point(-image.getWidth(null), -image.getHeight(null)));
        }
    }
}

