/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.SearchPopupCallback;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;

public class SearchPopup
extends ComponentAdapter
implements CaretListener {
    public final Type type;
    private final JBPopupListener myListener;
    private final JBTextField myEditor;
    private JBPopup myPopup;
    private LightweightWindowEvent myEvent;
    private Component myDialogComponent;
    public final CollectionListModel<Object> model;
    public JList<Object> list;
    public int caretPosition;
    public SearchPopupCallback callback;
    public boolean skipCaretEvent;
    public Object data;

    public SearchPopup(@NotNull SearchTextField searchTextField, @NotNull JBPopupListener listener2, @NotNull Type type, @NotNull CollectionListModel<Object> model, int caretPosition) {
        this.myEditor = searchTextField.getTextEditor();
        this.myListener = listener2;
        this.type = type;
        this.model = model;
        this.caretPosition = caretPosition;
    }

    public void createAndShow(@NotNull Consumer callback2, @NotNull ColoredListCellRenderer renderer, boolean async) {
        if (callback2 instanceof SearchPopupCallback) {
            this.callback = (SearchPopupCallback)callback2;
        }
        Insets ipad = renderer.getIpad();
        ipad.left = ipad.right = SearchPopup.getXOffset();
        renderer.setFont(this.myEditor.getFont());
        this.list = new JBList(this.model);
        this.myPopup = JBPopupFactory.getInstance().createListPopupBuilder((JList)this.list).setMovable(false).setResizable(false).setRequestFocus(false).setItemChosenCallback(callback2).setFont(this.myEditor.getFont()).setRenderer((ListCellRenderer)renderer).createPopup();
        this.myEvent = new LightweightWindowEvent((LightweightWindow)this.myPopup);
        this.skipCaretEvent = true;
        this.myPopup.addListener(this.myListener);
        this.myEditor.addCaretListener((CaretListener)this);
        this.myDialogComponent = this.myEditor.getRootPane().getParent();
        if (this.myDialogComponent != null) {
            this.myDialogComponent.addComponentListener(this);
        }
        if (async) {
            SwingUtilities.invokeLater(this::show);
        } else {
            this.show();
        }
    }

    private static int getXOffset() {
        int i2 = UIUtil.isUnderWin10LookAndFeel() ? 5 : UIUtil.getListCellHPadding();
        return JBUIScale.scale((int)i2);
    }

    @NotNull
    private Point getPopupLocation() {
        Point location;
        try {
            Rectangle view = this.myEditor.modelToView(this.caretPosition);
            location = new Point((int)view.getMaxX(), (int)view.getMaxY());
        }
        catch (BadLocationException ignore) {
            location = this.myEditor.getCaret().getMagicCaretPosition();
        }
        SwingUtilities.convertPointToScreen(location, (Component)this.myEditor);
        location.x -= SearchPopup.getXOffset() + JBUIScale.scale((int)2);
        location.y += 2;
        return location;
    }

    public boolean isValid() {
        return this.myPopup.isVisible() && this.myPopup.getContent().getParent() != null;
    }

    public void update() {
        this.skipCaretEvent = true;
        this.myPopup.setLocation(this.getPopupLocation());
        this.myPopup.pack(true, true);
    }

    private void show() {
        if (this.myPopup != null) {
            this.list.clearSelection();
            this.myPopup.showInScreenCoordinates((Component)this.myEditor, this.getPopupLocation());
        }
    }

    public void hide() {
        this.myEditor.removeCaretListener((CaretListener)this);
        if (this.myDialogComponent != null) {
            this.myDialogComponent.removeComponentListener(this);
            this.myDialogComponent = null;
        }
        if (this.myPopup != null) {
            this.myPopup.cancel();
            this.myPopup = null;
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.skipCaretEvent) {
            this.skipCaretEvent = false;
        } else {
            this.hide();
            this.myListener.onClosed(this.myEvent);
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.myPopup != null && this.isValid()) {
            this.update();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.componentMoved(e);
    }

    public static enum Type {
        AttributeName,
        AttributeValue,
        SearchQuery;

    }
}

