/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PluginsGroup {
    protected final String myTitlePrefix;
    public String title;
    public JLabel titleLabel;
    public LinkLabel<Object> rightAction;
    public List<JComponent> rightActions;
    public final List<IdeaPluginDescriptor> descriptors = new ArrayList<IdeaPluginDescriptor>();
    public UIPluginGroup ui;
    public Runnable clearCallback;

    public PluginsGroup(@NotNull @Nls String title) {
        this.myTitlePrefix = title;
        this.title = title;
    }

    public void clear() {
        this.ui = null;
        this.descriptors.clear();
        this.titleLabel = null;
        this.rightAction = null;
        this.rightActions = null;
        if (this.clearCallback != null) {
            this.clearCallback.run();
            this.clearCallback = null;
        }
    }

    public void addRightAction(@NotNull JComponent component2) {
        if (this.rightActions == null) {
            this.rightActions = new ArrayList<JComponent>();
        }
        this.rightActions.add(component2);
    }

    public void titleWithCount() {
        this.title = this.myTitlePrefix + " (" + this.descriptors.size() + ")";
        this.updateTitle();
    }

    public void titleWithEnabled(@NotNull MyPluginModel pluginModel) {
        int enabled = 0;
        for (IdeaPluginDescriptor descriptor2 : this.descriptors) {
            if (!pluginModel.isLoaded(descriptor2.getPluginId()) || !pluginModel.isEnabled(descriptor2) || PluginManagerCore.isIncompatible(descriptor2)) continue;
            ++enabled;
        }
        this.titleWithCount(enabled);
    }

    public void titleWithCount(int enabled) {
        this.title = IdeBundle.message((String)"plugins.configurable.title.with.count", (Object[])new Object[]{this.myTitlePrefix, enabled, this.descriptors.size()});
        this.updateTitle();
    }

    protected void updateTitle() {
        if (this.titleLabel != null) {
            this.titleLabel.setText(this.title);
        }
    }

    public int addWithIndex(@NotNull IdeaPluginDescriptor descriptor2) {
        this.descriptors.add(descriptor2);
        this.sortByName();
        return this.descriptors.indexOf(descriptor2);
    }

    public void sortByName() {
        PluginsGroup.sortByName(this.descriptors);
    }

    public static void sortByName(@NotNull List<? extends IdeaPluginDescriptor> descriptors) {
        ContainerUtil.sort(descriptors, (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true));
    }
}

