/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.CustomPluginRepositoryService;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Decompressor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginInstaller {
    private static final Logger LOG = Logger.getInstance(PluginInstaller.class);
    public static final String UNKNOWN_HOST_MARKER = "__unknown_repository__";
    static final Object ourLock = new Object();
    private static final String PLUGINS_PRESELECTION_PATH = "plugins.preselection.path";

    private PluginInstaller() {
    }

    public static boolean prepareToInstall(List<PluginNode> pluginsToInstall, List<? extends IdeaPluginDescriptor> customOrAllPlugins, boolean allowInstallWithoutRestart, PluginManagerMain.PluginEnabler pluginEnabler, Runnable onSuccess2, @NotNull ProgressIndicator indicator) {
        PluginInstallOperation operation = new PluginInstallOperation(pluginsToInstall, customOrAllPlugins, pluginEnabler, indicator);
        operation.setAllowInstallWithoutRestart(allowInstallWithoutRestart);
        operation.run();
        boolean success = operation.isSuccess();
        if (success) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (allowInstallWithoutRestart) {
                    for (PendingDynamicPluginInstall install : operation.getPendingDynamicPluginInstalls()) {
                        PluginInstaller.installAndLoadDynamicPlugin(install.getFile(), null, install.getPluginDescriptor());
                    }
                }
                if (onSuccess2 != null) {
                    onSuccess2.run();
                }
            });
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean prepareToUninstall(@NotNull IdeaPluginDescriptor pluginDescriptor) throws IOException {
        Object object = ourLock;
        synchronized (object) {
            if (PluginManagerCore.isPluginInstalled(pluginDescriptor.getPluginId())) {
                if (pluginDescriptor.isBundled()) {
                    LOG.error("Plugin is bundled: " + pluginDescriptor.getPluginId());
                } else {
                    boolean needRestart;
                    boolean bl = needRestart = !DynamicPlugins.allowLoadUnloadWithoutRestart((IdeaPluginDescriptorImpl)pluginDescriptor);
                    if (needRestart) {
                        PluginInstaller.uninstallAfterRestart(pluginDescriptor);
                    }
                    PluginStateManager.fireState(pluginDescriptor, false);
                    return needRestart;
                }
            }
        }
        return false;
    }

    private static void uninstallAfterRestart(IdeaPluginDescriptor pluginDescriptor) throws IOException {
        StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)new StartupActionScriptManager.DeleteCommand(pluginDescriptor.getPluginPath().toFile()));
    }

    public static boolean uninstallDynamicPlugin(@Nullable JComponent parentComponent, IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
        boolean uninstalledWithoutRestart;
        DynamicPlugins.UnloadPluginOptions options2 = new DynamicPlugins.UnloadPluginOptions().withUpdate(isUpdate).withWaitForClassloaderUnload(true);
        boolean bl = uninstalledWithoutRestart = parentComponent != null ? DynamicPlugins.unloadPluginWithProgress(null, parentComponent, (IdeaPluginDescriptorImpl)pluginDescriptor, options2) : DynamicPlugins.unloadPlugin((IdeaPluginDescriptorImpl)pluginDescriptor, options2);
        if (uninstalledWithoutRestart) {
            try {
                FileUtil.delete((Path)pluginDescriptor.getPluginPath());
            }
            catch (IOException e) {
                LOG.info("Failed to delete jar of dynamic plugin", (Throwable)e);
                uninstalledWithoutRestart = false;
            }
        }
        if (!uninstalledWithoutRestart) {
            try {
                PluginInstaller.uninstallAfterRestart(pluginDescriptor);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return uninstalledWithoutRestart;
    }

    @Deprecated
    public static void installAfterRestart(@NotNull File sourceFile, boolean deleteSourceFile, @Nullable File existingPlugin, @NotNull IdeaPluginDescriptor descriptor2) throws IOException {
    }

    public static void installAfterRestart(@NotNull File sourceFile, boolean deleteSourceFile, @Nullable Path existingPlugin, @NotNull IdeaPluginDescriptor descriptor2) throws IOException {
        ArrayList<Object> commands = new ArrayList<Object>();
        if (existingPlugin != null) {
            commands.add(new StartupActionScriptManager.DeleteCommand(existingPlugin.toFile()));
        }
        String pluginsPath = PathManager.getPluginsPath();
        if (sourceFile.getName().endsWith(".jar")) {
            commands.add(new StartupActionScriptManager.CopyCommand(sourceFile, new File(pluginsPath, sourceFile.getName())));
        } else {
            commands.add(new StartupActionScriptManager.DeleteCommand(new File(pluginsPath, PluginInstaller.rootEntryName(sourceFile))));
            commands.add(new StartupActionScriptManager.UnzipCommand(sourceFile, new File(pluginsPath)));
        }
        if (deleteSourceFile) {
            commands.add(new StartupActionScriptManager.DeleteCommand(sourceFile));
        }
        StartupActionScriptManager.addActionCommands(commands);
        PluginStateManager.fireState(descriptor2, true);
    }

    @Nullable
    public static File installWithoutRestart(File sourceFile, IdeaPluginDescriptorImpl descriptor2, Component parent) {
        Ref ref = new Ref();
        Ref refTarget = new Ref();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                refTarget.set((Object)PluginInstaller.unpackPlugin(sourceFile, PathManager.getPluginsPath()));
            }
            catch (IOException e) {
                ref.set((Object)e);
            }
        }, IdeBundle.message((String)"progress.title.installing.plugin", (Object[])new Object[0]), false, null, parent instanceof JComponent ? (JComponent)parent : null);
        IOException exception = (IOException)ref.get();
        if (exception != null) {
            Messages.showErrorDialog((Component)parent, (String)IdeBundle.message((String)"message.plugin.installation.failed.0", (Object[])new Object[]{exception.getMessage()}));
        }
        PluginStateManager.fireState(descriptor2, true);
        return exception != null ? null : (File)refTarget.get();
    }

    @NotNull
    public static File unpackPlugin(File sourceFile, String targetPath) throws IOException {
        File target2;
        if (sourceFile.getName().endsWith(".jar")) {
            target2 = new File(targetPath, sourceFile.getName());
            FileUtilRt.copy((File)sourceFile, (File)target2);
        } else {
            target2 = new File(targetPath, PluginInstaller.rootEntryName(sourceFile));
            FileUtil.delete((File)target2);
            new Decompressor.Zip(sourceFile).extract(new File(targetPath));
        }
        return target2;
    }

    private static String rootEntryName(File zip) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                int i2 = name.indexOf(47);
                if (i2 <= 0) continue;
                String string = name.substring(0, i2);
                return string;
            }
        }
        throw new IOException("Corrupted archive (no file entries): " + zip);
    }

    public static void addStateListener(@NotNull PluginStateListener listener2) {
        PluginStateManager.addStateListener(listener2);
    }

    public static boolean installFromDisk(@NotNull InstalledPluginsTableModel model, @NotNull File file2, @NotNull Consumer<? super PluginInstallCallbackData> callback2, @Nullable Component parent) {
        try {
            boolean installWithoutRestart;
            IdeaPluginDescriptorImpl pluginDescriptor = PluginDescriptorLoader.loadDescriptorFromArtifact(file2.toPath(), null);
            if (pluginDescriptor == null) {
                MessagesEx.showErrorDialog(parent, IdeBundle.message((String)"dialog.message.fail.to.load.plugin.descriptor.from.file", (Object[])new Object[]{file2.getName()}), CommonBundle.getErrorTitle());
                return false;
            }
            InstalledPluginsState ourState = InstalledPluginsState.getInstance();
            if (ourState.wasInstalled(pluginDescriptor.getPluginId())) {
                String message = IdeBundle.message((String)"dialog.message.plugin.was.already.installed", (Object[])new Object[]{pluginDescriptor.getName()});
                MessagesEx.showWarningDialog(parent, message, IdeBundle.message((String)"dialog.title.install.plugin", (Object[])new Object[0]));
                return false;
            }
            String incompatibleMessage = PluginManagerCore.getIncompatibleMessage(PluginManagerCore.getBuildNumber(), pluginDescriptor.getSinceBuild(), pluginDescriptor.getUntilBuild());
            if (incompatibleMessage != null || PluginManagerCore.isBrokenPlugin(pluginDescriptor)) {
                StringBuilder builder2 = new StringBuilder().append("Plugin '").append(pluginDescriptor.getName()).append("'");
                if (pluginDescriptor.getVersion() != null) {
                    builder2.append(" version ").append(pluginDescriptor.getVersion());
                }
                builder2.append(" is incompatible with this installation");
                if (incompatibleMessage != null) {
                    builder2.append(": ").append(incompatibleMessage);
                }
                MessagesEx.showErrorDialog(parent, builder2.toString(), CommonBundle.getErrorTitle());
                return false;
            }
            IdeaPluginDescriptor installedPlugin = PluginManagerCore.getPlugin(pluginDescriptor.getPluginId());
            if (installedPlugin != null && ApplicationInfoEx.getInstanceEx().isEssentialPlugin(installedPlugin.getPluginId())) {
                String message = IdeBundle.message((String)"dialog.message.plugin.core.part", (Object[])new Object[]{pluginDescriptor.getName(), ApplicationNamesInfo.getInstance().getFullProductName()});
                MessagesEx.showErrorDialog(parent, message, CommonBundle.getErrorTitle());
                return false;
            }
            PluginManagerMain.PluginEnabler pluginEnabler = model instanceof PluginManagerMain.PluginEnabler ? (PluginManagerMain.PluginEnabler)((Object)model) : new PluginManagerMain.PluginEnabler.HEADLESS();
            Ref cancel = Ref.create((Object)false);
            Ref toDisable = new Ref();
            Ref dependenciesRequireRestart = Ref.create((Object)false);
            HashSet installedDependencies = new HashSet();
            boolean success = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                PluginInstallOperation dependencyInstallOperation = new PluginInstallOperation(Collections.emptyList(), CustomPluginRepositoryService.getInstance().getCustomRepositoryPlugins(), pluginEnabler, ProgressManager.getInstance().getProgressIndicator());
                dependencyInstallOperation.setAllowInstallWithoutRestart(true);
                Ref<IdeaPluginDescriptor> ref = dependencyInstallOperation.checkDependenciesAndReplacements(pluginDescriptor, null);
                if (ref == null) {
                    cancel.set((Object)true);
                } else {
                    dependenciesRequireRestart.set((Object)dependencyInstallOperation.isRestartRequired());
                    installedDependencies.addAll(dependencyInstallOperation.getInstalledDependentPlugins());
                    toDisable.set(ref.get());
                }
            }, IdeBundle.message((String)"progress.title.checking.plugin.dependencies", (Object[])new Object[0]), true, null, (JComponent)parent);
            if (!success || ((Boolean)cancel.get()).booleanValue()) {
                return false;
            }
            Path oldFile = null;
            if (installedPlugin != null && !installedPlugin.isBundled()) {
                oldFile = installedPlugin.getPluginPath();
            }
            boolean bl = installWithoutRestart = oldFile == null && DynamicPlugins.allowLoadUnloadWithoutRestart(pluginDescriptor) && (Boolean)dependenciesRequireRestart.get() == false;
            if (!installWithoutRestart) {
                PluginInstaller.installAfterRestart(file2, false, oldFile, (IdeaPluginDescriptor)pluginDescriptor);
            }
            ourState.onPluginInstall(pluginDescriptor, installedPlugin != null, !installWithoutRestart);
            if (!toDisable.isNull()) {
                pluginEnabler.disablePlugins(Collections.singleton(toDisable.get()));
            }
            PluginInstaller.checkInstalledPluginDependencies(model, pluginDescriptor, parent, ContainerUtil.map2Set(installedDependencies, callbackData -> callbackData.getPluginDescriptor().getPluginId()));
            callback2.consume((Object)new PluginInstallCallbackData(file2, pluginDescriptor, !installWithoutRestart));
            for (PluginInstallCallbackData callbackData2 : installedDependencies) {
                if (callbackData2.getPluginDescriptor().getPluginId().equals(pluginDescriptor.getPluginId())) continue;
                callback2.consume((Object)callbackData2);
            }
            return true;
        }
        catch (IOException ex) {
            MessagesEx.showErrorDialog(parent, ex.getMessage(), CommonBundle.getErrorTitle());
            return false;
        }
    }

    public static boolean installAndLoadDynamicPlugin(@NotNull File file2, @Nullable Component parent, IdeaPluginDescriptorImpl pluginDescriptor) {
        IdeaPluginDescriptorImpl targetDescriptor;
        File targetFile = PluginInstaller.installWithoutRestart(file2, pluginDescriptor, parent);
        if (targetFile != null && (targetDescriptor = PluginManager.loadDescriptor(targetFile.toPath(), "plugin.xml")) != null) {
            return DynamicPlugins.loadPlugin(targetDescriptor);
        }
        return true;
    }

    private static void checkInstalledPluginDependencies(@NotNull InstalledPluginsTableModel model, @NotNull IdeaPluginDescriptorImpl pluginDescriptor, @Nullable Component parent, Set<PluginId> installedDependencies) {
        HashSet<PluginId> notInstalled = new HashSet<PluginId>();
        HashSet<PluginId> disabledIds = new HashSet<PluginId>();
        for (IdeaPluginDependency dep : pluginDescriptor.getDependencies()) {
            PluginId id2;
            if (dep.isOptional() || installedDependencies.contains(id2 = dep.getPluginId())) continue;
            boolean disabled = model.isDisabled(id2);
            boolean enabled = model.isEnabled(id2);
            if (!(enabled || disabled || PluginManagerCore.isModuleDependency(id2))) {
                notInstalled.add(id2);
                continue;
            }
            if (!disabled) continue;
            disabledIds.add(id2);
        }
        if (!notInstalled.isEmpty()) {
            String deps = StringUtil.join(notInstalled, PluginId::toString, (String)", ");
            String message = IdeBundle.message((String)"dialog.message.plugin.depends.on.unknown.plugin", (Object[])new Object[]{pluginDescriptor.getName(), notInstalled.size(), deps});
            MessagesEx.showWarningDialog(parent, message, IdeBundle.message((String)"dialog.title.install.plugin", (Object[])new Object[0]));
        }
        if (!disabledIds.isEmpty()) {
            HashSet<IdeaPluginDescriptor> dependencies = new HashSet<IdeaPluginDescriptor>();
            for (IdeaPluginDescriptor ideaPluginDescriptor : model.getAllPlugins()) {
                if (!disabledIds.contains(ideaPluginDescriptor.getPluginId())) continue;
                dependencies.add(ideaPluginDescriptor);
            }
            String deps = StringUtil.join(dependencies, PluginDescriptor::getName, (String)", ");
            String message = IdeBundle.message((String)"dialog.message.plugin.depends.on.enable", (Object[])new Object[]{pluginDescriptor.getName(), dependencies.size(), deps});
            if (Messages.showOkCancelDialog((String)message, (String)IdeBundle.message((String)"dialog.title.install.plugin", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.install", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon()) == 0) {
                model.enableRows(dependencies.toArray(new IdeaPluginDescriptor[0]), Boolean.TRUE);
            }
        }
    }

    static void chooseAndInstall(@NotNull InstalledPluginsTableModel model, @Nullable Component parent, @NotNull Consumer<? super PluginInstallCallbackData> callback2) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, false, true, true, false, false){

            public boolean isFileSelectable(VirtualFile file2) {
                String extension = file2.getExtension();
                return Comparing.strEqual((String)extension, (String)"jar") || Comparing.strEqual((String)extension, (String)"zip");
            }
        };
        descriptor2.setTitle(IdeBundle.message((String)"chooser.title.plugin.file", (Object[])new Object[0]));
        descriptor2.setDescription(IdeBundle.message((String)"chooser.description.jar.and.zip.archives.are.accepted", (Object[])new Object[0]));
        String oldPath = PropertiesComponent.getInstance().getValue(PLUGINS_PRESELECTION_PATH);
        VirtualFile toSelect2 = oldPath == null ? null : VfsUtil.findFileByIoFile((File)new File(FileUtil.toSystemDependentName((String)oldPath)), (boolean)false);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor2, null, (Component)parent, (VirtualFile)toSelect2, virtualFile -> {
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            PropertiesComponent.getInstance().setValue(PLUGINS_PRESELECTION_PATH, FileUtil.toSystemIndependentName((String)file2.getParent()));
            PluginInstaller.installFromDisk(model, file2, callback2, parent);
        });
    }
}

