/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginReplacement;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.marketplace.PluginModulesHelper;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginInstallOperation {
    private static final Logger LOG = Logger.getInstance(PluginInstallOperation.class);
    private final List<PluginNode> myPluginsToInstall;
    private final Collection<? extends IdeaPluginDescriptor> myCustomReposPlugins;
    private final PluginManagerMain.PluginEnabler myPluginEnabler;
    private final ProgressIndicator myIndicator;
    private boolean mySuccess = true;
    private final Set<PluginInstallCallbackData> myDependant = new HashSet<PluginInstallCallbackData>();
    private boolean myAllowInstallWithoutRestart = false;
    private final List<PendingDynamicPluginInstall> myPendingDynamicPluginInstalls = new ArrayList<PendingDynamicPluginInstall>();
    private boolean myRestartRequired = false;
    private boolean myShownErrors;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public PluginInstallOperation(@NotNull List<PluginNode> pluginsToInstall, List<? extends IdeaPluginDescriptor> customReposPlugins, PluginManagerMain.PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator) {
        this(pluginsToInstall, (Collection<? extends IdeaPluginDescriptor>)customReposPlugins, pluginEnabler, indicator);
    }

    public PluginInstallOperation(@NotNull List<PluginNode> pluginsToInstall, Collection<? extends IdeaPluginDescriptor> customReposPlugins, PluginManagerMain.PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator) {
        this.myPluginsToInstall = pluginsToInstall;
        this.myCustomReposPlugins = customReposPlugins;
        this.myPluginEnabler = pluginEnabler;
        this.myIndicator = indicator;
    }

    public void setAllowInstallWithoutRestart(boolean allowInstallWithoutRestart) {
        this.myAllowInstallWithoutRestart = allowInstallWithoutRestart;
    }

    public List<PendingDynamicPluginInstall> getPendingDynamicPluginInstalls() {
        return this.myPendingDynamicPluginInstalls;
    }

    public boolean isRestartRequired() {
        return this.myRestartRequired;
    }

    public void run() {
        this.updateUrls();
        this.mySuccess = this.prepareToInstall(this.myPluginsToInstall);
    }

    public boolean isSuccess() {
        return this.mySuccess;
    }

    public Set<PluginInstallCallbackData> getInstalledDependentPlugins() {
        return this.myDependant;
    }

    public boolean isShownErrors() {
        return this.myShownErrors;
    }

    private void updateUrls() {
        boolean unknownNodes = false;
        for (PluginNode node : this.myPluginsToInstall) {
            if (node.getRepositoryName() != "__unknown_repository__") continue;
            unknownNodes = true;
            break;
        }
        if (!unknownNodes) {
            return;
        }
        SmartList hosts = new SmartList();
        ContainerUtil.addIfNotNull((Collection)hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.addAll(UpdateSettings.getInstance().getPluginHosts());
        HashMap<PluginId, IdeaPluginDescriptor> allPlugins = new HashMap<PluginId, IdeaPluginDescriptor>();
        for (String host : hosts) {
            try {
                List<IdeaPluginDescriptor> descriptors = RepositoryHelper.loadPlugins(host, this.myIndicator);
                for (IdeaPluginDescriptor descriptor2 : descriptors) {
                    allPlugins.put(descriptor2.getPluginId(), descriptor2);
                }
            }
            catch (IOException descriptors) {
            }
        }
        for (PluginNode node : this.myPluginsToInstall) {
            if (node.getRepositoryName() != "__unknown_repository__") continue;
            IdeaPluginDescriptor descriptor3 = (IdeaPluginDescriptor)allPlugins.get(node.getPluginId());
            if (descriptor3 != null) {
                node.setRepositoryName(((PluginNode)descriptor3).getRepositoryName());
                node.setDownloadUrl(((PluginNode)descriptor3).getDownloadUrl());
                continue;
            }
            node.setRepositoryName(null);
        }
    }

    private boolean prepareToInstall(@NotNull List<PluginNode> pluginsToInstall) {
        SmartList pluginIds = new SmartList();
        for (PluginNode pluginNode : pluginsToInstall) {
            pluginIds.add(pluginNode.getPluginId());
        }
        boolean result2 = false;
        for (PluginNode pluginNode : pluginsToInstall) {
            this.myIndicator.setText(pluginNode.getName());
            try {
                result2 |= this.prepareToInstall(pluginNode, (List<PluginId>)pluginIds);
            }
            catch (IOException e) {
                String title = IdeBundle.message((String)"title.plugin.error", (Object[])new Object[0]);
                Notifications.Bus.notify((Notification)new Notification(NotificationGroup.createIdWithTitle((String)"Plugin Error", (String)title), title, pluginNode.getName() + ": " + e.getMessage(), NotificationType.ERROR));
                return false;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareToInstall(PluginNode pluginNode, List<PluginId> pluginIds) throws IOException {
        Ref<IdeaPluginDescriptor> toDisable = this.checkDependenciesAndReplacements(pluginNode, pluginIds);
        if (toDisable == null) {
            return false;
        }
        this.myShownErrors = false;
        PluginDownloader downloader = PluginDownloader.createDownloader(pluginNode, pluginNode.getRepositoryName(), null);
        IdeaPluginDescriptorImpl descriptor2 = downloader.prepareToInstallAndLoadDescriptor(this.myIndicator);
        if (descriptor2 != null) {
            boolean allowNoRestart;
            if (pluginNode.getDependencies().isEmpty() && !descriptor2.getDependencies().isEmpty() && !this.checkMissingDependencies(descriptor2, pluginIds)) {
                return false;
            }
            boolean bl = allowNoRestart = this.myAllowInstallWithoutRestart && DynamicPlugins.allowLoadUnloadWithoutRestart(descriptor2);
            if (allowNoRestart) {
                this.myPendingDynamicPluginInstalls.add(new PendingDynamicPluginInstall(downloader.getFile(), descriptor2));
                InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
                if (state != null) {
                    state.onPluginInstall(downloader.getDescriptor(), false, false);
                }
            } else {
                this.myRestartRequired = true;
                Object object = PluginInstaller.ourLock;
                synchronized (object) {
                    downloader.install();
                }
            }
            this.myDependant.add(new PluginInstallCallbackData(downloader.getFile(), descriptor2, !allowNoRestart));
            pluginNode.setStatus(PluginNode.Status.DOWNLOADED);
            if (!toDisable.isNull()) {
                this.myPluginEnabler.disablePlugins(Collections.singleton(toDisable.get()));
            }
        } else {
            this.myShownErrors = downloader.isShownErrors();
            return false;
        }
        return true;
    }

    @Nullable
    public Ref<IdeaPluginDescriptor> checkDependenciesAndReplacements(IdeaPluginDescriptor pluginNode, @Nullable List<PluginId> pluginIds) {
        if (!this.checkMissingDependencies(pluginNode, pluginIds)) {
            return null;
        }
        Ref toDisable = Ref.create(null);
        PluginReplacement pluginReplacement = (PluginReplacement)ContainerUtil.find((Object[])PluginReplacement.EP_NAME.getExtensions(), r -> r.getNewPluginId().equals(pluginNode.getPluginId().getIdString()));
        if (pluginReplacement != null) {
            IdeaPluginDescriptor oldPlugin = PluginManagerCore.getPlugin(pluginReplacement.getOldPluginDescriptor().getPluginId());
            if (oldPlugin == null) {
                LOG.warn("Plugin with id '" + pluginReplacement.getOldPluginDescriptor().getPluginId() + "' not found");
            } else if (!this.myPluginEnabler.isDisabled(oldPlugin.getPluginId())) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    String title = IdeBundle.message((String)"plugin.manager.obsolete.plugins.detected.title", (Object[])new Object[0]);
                    String message = pluginReplacement.getReplacementMessage(oldPlugin, pluginNode);
                    if (Messages.showYesNoDialog((String)message, (String)title, (String)IdeBundle.message((String)"button.disable", (Object[])new Object[0]), (String)Messages.getNoButton(), (Icon)Messages.getWarningIcon()) == 0) {
                        toDisable.set((Object)oldPlugin);
                    }
                }, ModalityState.any());
            }
        }
        return toDisable;
    }

    private boolean checkMissingDependencies(IdeaPluginDescriptor pluginNode, @Nullable List<PluginId> pluginIds) {
        List dependencies = pluginNode.getDependencies();
        if (!dependencies.isEmpty()) {
            boolean[] proceed;
            ArrayList<PluginNode> depends = new ArrayList<PluginNode>();
            ArrayList<PluginNode> optionalDeps = new ArrayList<PluginNode>();
            for (IdeaPluginDependency dependency : dependencies) {
                PluginId depPluginId = dependency.getPluginId();
                if (PluginManagerCore.isModuleDependency(depPluginId)) {
                    PluginId pluginIdByModule = PluginModulesHelper.getInstance().getMarketplacePluginIdByModule(depPluginId);
                    if (pluginIdByModule == null) continue;
                    depPluginId = pluginIdByModule;
                }
                if (PluginManagerCore.isPluginInstalled(depPluginId) || InstalledPluginsState.getInstance().wasInstalled(depPluginId) || InstalledPluginsState.getInstance().wasInstalledWithoutRestart(depPluginId) || pluginIds != null && pluginIds.contains(depPluginId)) continue;
                IdeaPluginDescriptor depPluginDescriptor = this.findPluginInRepo(depPluginId);
                PluginNode depPlugin = depPluginDescriptor instanceof PluginNode ? (PluginNode)depPluginDescriptor : new PluginNode(depPluginId, depPluginId.getIdString(), "-1");
                if (depPluginDescriptor == null) continue;
                if (dependency.isOptional()) {
                    optionalDeps.add(depPlugin);
                    continue;
                }
                depends.add(depPlugin);
            }
            if (!depends.isEmpty()) {
                proceed = new boolean[1];
                try {
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        String title = IdeBundle.message((String)"plugin.manager.dependencies.detected.title", (Object[])new Object[0]);
                        String deps = PluginInstallOperation.getPluginsText(depends);
                        String message = IdeBundle.message((String)"plugin.manager.dependencies.detected.message", (Object[])new Object[]{pluginNode.getName(), deps});
                        proceed[0] = Messages.showYesNoDialog((String)message, (String)title, (String)IdeBundle.message((String)"button.install", (Object[])new Object[0]), (String)Messages.getNoButton(), (Icon)Messages.getWarningIcon()) == 0;
                    }, ModalityState.any());
                }
                catch (Exception e) {
                    return false;
                }
                if (!proceed[0] || !this.prepareToInstall(depends)) {
                    return false;
                }
            }
            if (!optionalDeps.isEmpty() && Registry.is((String)"ide.plugins.suggest.install.optional.dependencies")) {
                proceed = new boolean[1];
                try {
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        String title = IdeBundle.message((String)"plugin.manager.optional.dependencies.detected.title", (Object[])new Object[0]);
                        String deps = PluginInstallOperation.getPluginsText(optionalDeps);
                        String message = IdeBundle.message((String)"plugin.manager.optional.dependencies.detected.message", (Object[])new Object[]{pluginNode.getName(), deps});
                        proceed[0] = Messages.showYesNoDialog((String)message, (String)title, (String)IdeBundle.message((String)"button.install", (Object[])new Object[0]), (String)Messages.getNoButton(), (Icon)Messages.getWarningIcon()) == 0;
                    }, ModalityState.any());
                }
                catch (Exception e) {
                    return false;
                }
                if (proceed[0] && !this.prepareToInstall(optionalDeps)) {
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    private static String getPluginsText(@NotNull List<PluginNode> pluginNodes) {
        int size = pluginNodes.size();
        if (size == 1) {
            return "\"" + pluginNodes.get(0).getName() + "\" plugin";
        }
        return StringUtil.join(pluginNodes.subList(0, size - 1), node -> "\"" + node.getName() + "\"", (String)", ") + " and \"" + pluginNodes.get(size - 1) + "\" plugins";
    }

    @Nullable
    private IdeaPluginDescriptor findPluginInRepo(PluginId depPluginId) {
        IdeaPluginDescriptor pluginFromCustomRepos = ((Stream)this.myCustomReposPlugins.stream().parallel()).filter(p -> p.getPluginId().equals(depPluginId)).findAny().orElse(null);
        PluginNode pluginFromMarketplace = MarketplaceRequests.getInstance().getLastCompatiblePluginUpdate(depPluginId.getIdString());
        if (pluginFromCustomRepos == null) {
            return pluginFromMarketplace;
        }
        if (pluginFromMarketplace == null) {
            return pluginFromCustomRepos;
        }
        if (PluginDownloader.compareVersionsSkipBrokenAndIncompatible(pluginFromCustomRepos.getVersion(), pluginFromMarketplace) > 0) {
            return pluginFromCustomRepos;
        }
        return pluginFromMarketplace;
    }
}

