/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarModelBuilder;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.navigationToolbar.NavBarModelListener;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.NavBarPresentation;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarModel {
    private List<Object> myModel = Collections.emptyList();
    private int mySelectedIndex;
    private final Project myProject;
    private final NavBarModelListener myNotificator;
    private final NavBarModelBuilder myBuilder;
    private boolean myChanged = true;
    private boolean updated = false;
    private boolean isFixedComponent = false;

    public NavBarModel(Project project) {
        this(project, (NavBarModelListener)project.getMessageBus().syncPublisher(NavBarModelListener.NAV_BAR), NavBarModelBuilder.getInstance());
    }

    protected NavBarModel(Project project, NavBarModelListener notificator, NavBarModelBuilder builder2) {
        this.myProject = project;
        this.myNotificator = notificator;
        this.myBuilder = builder2;
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex;
    }

    @Nullable
    public Object getSelectedValue() {
        return this.getElement(this.mySelectedIndex);
    }

    @Nullable
    public Object getElement(int index) {
        if (index != -1 && index < this.myModel.size()) {
            return this.get(index);
        }
        return null;
    }

    public int size() {
        return this.myModel.size();
    }

    public boolean isEmpty() {
        return this.myModel.isEmpty();
    }

    public int getIndexByModel(int index) {
        if (index < 0) {
            return this.myModel.size() + index;
        }
        if (index >= this.myModel.size() && this.myModel.size() > 0) {
            return index % this.myModel.size();
        }
        return index;
    }

    protected void updateModel(DataContext dataContext) {
        if (LaterInvocator.isInModalContext() || this.updated && !this.isFixedComponent) {
            return;
        }
        if (PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext) instanceof NavBarPanel) {
            return;
        }
        NavBarModelExtension ownerExtension = null;
        PsiElement psiElement = null;
        for (NavBarModelExtension extension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            psiElement = extension.getLeafElement(dataContext);
            if (psiElement == null) continue;
            ownerExtension = extension;
            break;
        }
        if (psiElement == null) {
            psiElement = (PsiElement)CommonDataKeys.PSI_FILE.getData(dataContext);
        }
        if (psiElement == null && (psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) == null) {
            psiElement = PsiUtilCore.findFileSystemItem((Project)((Project)CommonDataKeys.PROJECT.getData(dataContext)), (VirtualFile)((VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)));
        }
        if (ownerExtension == null) {
            psiElement = NavBarModel.normalize(psiElement);
        }
        if (!this.myModel.isEmpty() && Objects.equals(this.get(this.myModel.size() - 1), psiElement) && !this.myChanged) {
            return;
        }
        if (psiElement != null && psiElement.isValid()) {
            this.updateModel(psiElement, ownerExtension);
        } else {
            if (UISettings.getInstance().getShowNavigationBar() && !this.myModel.isEmpty()) {
                return;
            }
            Object root = this.calculateRoot(dataContext);
            if (root != null) {
                this.setModel(Collections.singletonList(root));
            }
        }
        this.setChanged(false);
        this.updated = true;
    }

    private Object calculateRoot(DataContext dataContext) {
        Module root = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (root != null && !ModuleType.isInternal((Module)root)) {
            return root;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Object projectGrandChild = null;
        CommonProcessors.FindFirstAndOnlyProcessor processor2 = new CommonProcessors.FindFirstAndOnlyProcessor();
        this.processChildren(project, (Processor<Object>)processor2);
        Object projectChild = processor2.reset();
        if (projectChild != null) {
            this.processChildren(projectChild, (Processor<Object>)processor2);
            projectGrandChild = processor2.reset();
        }
        return ObjectUtils.chooseNotNull(projectGrandChild, (Object)ObjectUtils.chooseNotNull((Object)projectChild, (Object)project));
    }

    protected void updateModel(PsiElement psiElement, @Nullable NavBarModelExtension ownerExtension) {
        VirtualFile parent;
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        for (VirtualFile root : projectRootManager.getContentRoots()) {
            parent = root.getParent();
            if (parent != null && projectFileIndex.isInContent(parent)) continue;
            roots.add(root);
        }
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            for (VirtualFile root : modelExtension.additionalRoots(psiElement.getProject())) {
                parent = root.getParent();
                if (parent != null && projectFileIndex.isInContent(parent)) continue;
                roots.add(root);
            }
        }
        List updatedModel = (List)ReadAction.compute(() -> NavBarModel.isValid(psiElement) ? this.myBuilder.createModel(psiElement, roots, ownerExtension) : Collections.emptyList());
        this.setModel(ContainerUtil.reverse((List)updatedModel));
    }

    void revalidate() {
        ArrayList<Object> objects = new ArrayList<Object>();
        boolean update2 = false;
        for (Object o : this.myModel) {
            if (NavBarModel.isValid(TreeAnchorizer.getService().retrieveElement(o))) {
                objects.add(o);
                continue;
            }
            update2 = true;
            break;
        }
        if (update2) {
            this.setModel(objects);
        }
    }

    protected void setModel(List<Object> model) {
        this.setModel(model, false);
    }

    protected void setModel(List<Object> model, boolean force) {
        if (!model.equals(TreeAnchorizer.retrieveList(this.myModel))) {
            this.myModel = TreeAnchorizer.anchorizeList(model);
            this.myNotificator.modelChanged();
            this.mySelectedIndex = this.myModel.size() - 1;
            this.myNotificator.selectionChanged();
        } else if (force) {
            this.myModel = TreeAnchorizer.anchorizeList(model);
            this.myNotificator.modelChanged();
        }
    }

    public void updateModel(Object object) {
        if (object instanceof PsiElement) {
            this.updateModel((PsiElement)object, null);
        } else if (object instanceof Module) {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(this.myProject);
            l.add(object);
            this.setModel(l);
        }
    }

    protected boolean hasChildren(Object object) {
        return !this.processChildren(object, (Processor<Object>)new CommonProcessors.FindFirstProcessor());
    }

    public void setChanged(boolean changed2) {
        this.myChanged = changed2;
    }

    static boolean isValid(Object object) {
        if (object instanceof Project) {
            return !((Project)object).isDisposed();
        }
        if (object instanceof Module) {
            return !((Module)object).isDisposed();
        }
        if (object instanceof PsiElement) {
            return (Boolean)ReadAction.compute(() -> ((PsiElement)object).isValid());
        }
        return object != null;
    }

    @Nullable
    public static PsiElement normalize(@Nullable PsiElement child2) {
        if (child2 == null) {
            return null;
        }
        List extensions2 = NavBarModelExtension.EP_NAME.getExtensionList();
        for (int i2 = extensions2.size() - 1; i2 >= 0; --i2) {
            NavBarModelExtension modelExtension = (NavBarModelExtension)extensions2.get(i2);
            child2 = modelExtension.adjustElement(child2);
            if (child2 != null) continue;
            return null;
        }
        return child2;
    }

    protected List<Object> getChildren(Object object) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        PairProcessor processor2 = (o, ext) -> {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)(o instanceof PsiElement && ext.normalizeChildren() ? NavBarModel.normalize((PsiElement)o) : o));
            return true;
        };
        this.processChildrenWithExtensions(object, (PairProcessor<Object, NavBarModelExtension>)processor2);
        result2.sort(new SiblingsComparator());
        return result2;
    }

    private boolean processChildren(Object object, @NotNull Processor<Object> processor2) {
        return this.processChildrenWithExtensions(object, (PairProcessor<Object, NavBarModelExtension>)((PairProcessor)(o, ext) -> processor2.process(o)));
    }

    private boolean processChildrenWithExtensions(Object object, @NotNull PairProcessor<Object, NavBarModelExtension> pairProcessor) {
        Object rootElement;
        if (!NavBarModel.isValid(object)) {
            return true;
        }
        Object object2 = rootElement = this.size() > 1 ? this.getElement(1) : null;
        if (rootElement != null && !NavBarModel.isValid(rootElement)) {
            return true;
        }
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            if (modelExtension.processChildren(object, rootElement, (Processor<Object>)((Processor)o -> pairProcessor.process(o, (Object)modelExtension)))) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        return TreeAnchorizer.getService().retrieveElement(this.myModel.get(index));
    }

    public int indexOf(Object value2) {
        for (int i2 = 0; i2 < this.myModel.size(); ++i2) {
            Object o = this.myModel.get(i2);
            if (!Objects.equals(TreeAnchorizer.getService().retrieveElement(o), value2)) continue;
            return i2;
        }
        return -1;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (this.mySelectedIndex != selectedIndex) {
            this.mySelectedIndex = selectedIndex;
            this.myNotificator.selectionChanged();
        }
    }

    public void setFixedComponent(boolean fixedComponent) {
        this.isFixedComponent = fixedComponent;
    }

    private static final class SiblingsComparator
    implements Comparator<Object> {
        private SiblingsComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int w1 = SiblingsComparator.getWeight(o1);
            int w2 = SiblingsComparator.getWeight(o2);
            if (w1 == 0) {
                return w2 == 0 ? 0 : -1;
            }
            if (w2 == 0) {
                return 1;
            }
            if (w1 != w2) {
                return -w1 + w2;
            }
            String s1 = NavBarPresentation.calcPresentableText(o1, false);
            String s2 = NavBarPresentation.calcPresentableText(o2, false);
            return StringUtil.naturalCompare((String)s1, (String)s2);
        }

        private static int getWeight(Object object) {
            return object instanceof Module ? 5 : (object instanceof PsiDirectoryContainer ? 4 : (object instanceof PsiDirectory ? 4 : (object instanceof PsiFile ? 2 : (object instanceof PsiNamedElement ? 3 : 0))));
        }
    }
}

