/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.project;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.lightEdit.project.LightEditProjectImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.util.TimeoutUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditProjectManager {
    private static final Logger LOG = Logger.getInstance(LightEditProjectManager.class);
    private static final Object LOCK = new Object();
    private volatile LightEditProjectImpl myProject;

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Project getOrCreateProject() {
        LightEditProjectImpl project = this.myProject;
        if (project == null) {
            Object object = LOCK;
            synchronized (object) {
                if (this.myProject == null) {
                    this.myProject = LightEditProjectManager.createProject();
                }
                project = this.myProject;
            }
        }
        return project;
    }

    @NotNull
    private static LightEditProjectImpl createProject() {
        long start2 = System.nanoTime();
        LightEditProjectImpl project = new LightEditProjectImpl();
        LOG.info(LightEditProjectImpl.class.getSimpleName() + " loaded in " + TimeoutUtil.getDurationMillis((long)start2) + " ms");
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LightEditProjectImpl project = this.myProject;
        if (project != null) {
            SaveAndSyncHandler.getInstance().saveSettingsUnderModalProgress((ComponentManager)project);
            ProjectManagerEx.getInstanceEx().forceCloseProject(project);
        }
        Object object = LOCK;
        synchronized (object) {
            this.myProject = null;
        }
    }
}

