/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.actions.associate.linux;

import com.intellij.ide.lightEdit.actions.associate.FileAssociationException;
import com.intellij.ide.lightEdit.actions.associate.SystemFileTypeAssociator;
import com.intellij.ide.lightEdit.actions.associate.linux.LinuxMimeTypeUpdater;
import com.intellij.ide.lightEdit.actions.associate.linux.MimeTypeDescription;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LinuxFileTypeAssociator
implements SystemFileTypeAssociator {
    @Override
    public void associateFileTypes(@NotNull List<FileType> fileTypes) throws FileAssociationException {
        LinuxMimeTypeUpdater.updateMimeTypes(LinuxFileTypeAssociator.convertToMimeTypes(fileTypes));
    }

    private static List<MimeTypeDescription> convertToMimeTypes(@NotNull List<FileType> fileTypes) {
        List mimeTypeDescriptions = ContainerUtil.map(fileTypes, fileType -> new MimeTypeDescription((FileType)fileType));
        mimeTypeDescriptions.sort(Comparator.comparing(description -> description.getType()));
        return mimeTypeDescriptions;
    }
}

