/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.lightEdit.LightEditDropHandler;
import com.intellij.ide.lightEdit.LightEditFileTypeOverrider;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditServiceImpl;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorInfoImpl;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditorManagerImpl
implements LightEditorManager,
Disposable {
    private static final Logger LOG = Logger.getInstance(LightEditorManagerImpl.class);
    private final List<LightEditorInfo> myEditors = new CopyOnWriteArrayList<LightEditorInfo>();
    private final EventDispatcher<LightEditorListener> myEventDispatcher = EventDispatcher.create(LightEditorListener.class);
    private final LightEditServiceImpl myLightEditService;
    static final Key<Boolean> NO_IMPLICIT_SAVE = Key.create((String)"light.edit.no.implicit.save");
    private static final String DEFAULT_FILE_NAME = "untitled_";

    public LightEditorManagerImpl(LightEditServiceImpl service) {
        this.myLightEditService = service;
    }

    @Nullable
    private LightEditorInfo doCreateEditor(@NotNull VirtualFile file2) {
        Project project = Objects.requireNonNull(LightEditUtil.getProject());
        Pair<FileEditorProvider, FileEditor> pair = LightEditorManagerImpl.createFileEditor(project, file2);
        if (pair == null) {
            return null;
        }
        LightEditorInfoImpl editorInfo = new LightEditorInfoImpl((FileEditorProvider)pair.first, (FileEditor)pair.second, file2);
        ObjectUtils.consumeIfCast((Object)LightEditorInfoImpl.getEditor(editorInfo), EditorImpl.class, editorImpl -> editorImpl.setDropHandler(new LightEditDropHandler()));
        this.myEditors.add(editorInfo);
        ((FileEditorManagerListener)project.getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER)).fileOpened(FileEditorManager.getInstance((Project)project), file2);
        return editorInfo;
    }

    @Nullable
    private static Pair<FileEditorProvider, FileEditor> createFileEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        int n = 0;
        FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(project, file2);
        FileEditorProvider[] fileEditorProviderArray = providers;
        int n2 = fileEditorProviderArray.length;
        if (n < n2) {
            FileEditorProvider provider = fileEditorProviderArray[n];
            FileEditor editor = provider.createEditor(project, file2);
            return Pair.create((Object)provider, (Object)editor);
        }
        return null;
    }

    @NotNull
    public LightEditorInfo createEditor() {
        LightVirtualFile file2 = new LightVirtualFile(this.getUniqueName());
        file2.setFileType((FileType)PlainTextFileType.INSTANCE);
        return Objects.requireNonNull(this.doCreateEditor((VirtualFile)file2));
    }

    @Nullable
    public LightEditorInfo createEditor(@NotNull VirtualFile file2) {
        LightEditFileTypeOverrider.markUnknownFileTypeAsPlainText(file2);
        LightEditorManagerImpl.setImplicitSaveEnabled(file2, false);
        LightEditorInfo editorInfo = this.doCreateEditor(file2);
        Editor editor = LightEditorInfoImpl.getEditor(editorInfo);
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).setHighlighter(LightEditorManagerImpl.getHighlighter(file2, editor));
        }
        return editorInfo;
    }

    private static void setImplicitSaveEnabled(@NotNull VirtualFile file2, boolean isEnabled) {
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document != null) {
            document.putUserData(NO_IMPLICIT_SAVE, (Object)(isEnabled ? null : Boolean.valueOf(true)));
        }
    }

    public void dispose() {
        this.releaseEditors();
    }

    public void releaseEditors() {
        this.myEditors.forEach(editorInfo -> ((LightEditorInfoImpl)editorInfo).disposeEditor());
        this.myEditors.clear();
    }

    public void closeEditor(@NotNull LightEditorInfo editorInfo) {
        this.myEditors.remove(editorInfo);
        LightEditorManagerImpl.setImplicitSaveEnabled(editorInfo.getFile(), true);
        ((LightEditorInfoImpl)editorInfo).disposeEditor();
        ((LightEditorListener)this.myEventDispatcher.getMulticaster()).afterClose(editorInfo);
    }

    public void addListener(@NotNull LightEditorListener listener2) {
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public void addListener(@NotNull LightEditorListener listener2, @NotNull Disposable parent) {
        this.myEventDispatcher.addListener((EventListener)listener2, parent);
    }

    void fireEditorSelected(@Nullable LightEditorInfo editorInfo) {
        ((LightEditorListener)this.myEventDispatcher.getMulticaster()).afterSelect(editorInfo);
    }

    void fireAutosaveModeChanged(boolean autosaveMode) {
        ((LightEditorListener)this.myEventDispatcher.getMulticaster()).autosaveModeChanged(autosaveMode);
    }

    void fireFileStatusChanged(@NotNull Collection<LightEditorInfo> editorInfos) {
        ((LightEditorListener)this.myEventDispatcher.getMulticaster()).fileStatusChanged(editorInfos);
    }

    @NotNull
    private static EditorHighlighter getHighlighter(@NotNull VirtualFile file2, @NotNull Editor editor) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter(file2, editor.getColorsScheme(), null);
    }

    int getEditorCount() {
        return this.myEditors.size();
    }

    @Nullable
    public LightEditorInfo findOpen(@NotNull VirtualFile file2) {
        return this.myEditors.stream().filter(editorInfo -> file2.getPath().equals(editorInfo.getFile().getPath())).findFirst().orElse(null);
    }

    public boolean isImplicitSaveAllowed(@NotNull Document document) {
        return LightEditService.getInstance().isAutosaveMode() || (Boolean)ObjectUtils.notNull((Object)document.getUserData(NO_IMPLICIT_SAVE), (Object)false) == false;
    }

    @NotNull
    public Collection<VirtualFile> getOpenFiles() {
        return this.myEditors.stream().map(info -> info.getFile()).collect(Collectors.toSet());
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        return this.myEditors.stream().anyMatch(editorInfo -> file2.equals(editorInfo.getFile()));
    }

    public boolean containsUnsavedDocuments() {
        return this.myEditors.stream().anyMatch(editorInfo -> editorInfo.isUnsaved());
    }

    @NotNull
    List<LightEditorInfo> getUnsavedEditors() {
        return ContainerUtil.filter(this.myEditors, editorInfo -> editorInfo.isUnsaved());
    }

    private String getUniqueName() {
        int i2 = 1;
        while (true) {
            String candidate = DEFAULT_FILE_NAME + i2;
            if (this.myEditors.stream().noneMatch(editorInfo -> editorInfo.getFile().getName().equals(candidate))) {
                return candidate;
            }
            ++i2;
        }
    }

    @NotNull
    public LightEditorInfo saveAs(@NotNull LightEditorInfo info, @NotNull VirtualFile targetFile) {
        LightEditorInfo newInfo = this.createEditor(targetFile);
        if (newInfo != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                FileDocumentManager manager = FileDocumentManager.getInstance();
                Document source = manager.getDocument(info.getFile());
                Document target2 = manager.getDocument(targetFile);
                if (source == null) {
                    LOG.error("Cannot save to " + targetFile + ": no document found for " + info.getFile());
                    return;
                }
                if (target2 == null) {
                    LOG.error("Cannot save to " + targetFile + ": no document found for " + targetFile);
                    return;
                }
                targetFile.refresh(false, false);
                target2.setText(source.getCharsSequence());
                manager.saveDocument(target2);
            });
            return newInfo;
        }
        return info;
    }

    @Nullable
    LightEditorInfo getEditorInfo(@NotNull VirtualFile file2) {
        return this.myEditors.stream().filter(editorInfo -> file2.equals(editorInfo.getFile())).findFirst().orElse(null);
    }
}

