/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.lightEdit.LightEditPanel;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.ide.lightEdit.menuBar.LightEditMenuBar;
import com.intellij.ide.lightEdit.statusBar.LightEditAutosaveWidget;
import com.intellij.ide.lightEdit.statusBar.LightEditEncodingWidgetWrapper;
import com.intellij.ide.lightEdit.statusBar.LightEditLineSeparatorWidgetWrapper;
import com.intellij.ide.lightEdit.statusBar.LightEditPositionWidget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectFrameAllocatorKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.LightEditFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.CloseProjectWindowHelper;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.PopupHandler;
import java.awt.Component;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LightEditFrameWrapper
extends ProjectFrameHelper
implements Disposable,
LightEditFrame {
    private final BooleanSupplier myCloseHandler;
    private LightEditPanel myEditPanel;

    LightEditFrameWrapper(@NotNull IdeFrameImpl frame, @NotNull BooleanSupplier closeHandler) {
        super(frame, null);
        this.myCloseHandler = closeHandler;
    }

    @NotNull
    LightEditPanel getLightEditPanel() {
        return this.myEditPanel;
    }

    @Override
    @NotNull
    protected IdeRootPane createIdeRootPane() {
        return new LightEditRootPane(this.getFrame(), this, this);
    }

    @Override
    protected void installDefaultProjectStatusBarWidgets(@NotNull Project project) {
        LightEditorManager editorManager = LightEditService.getInstance().getEditorManager();
        IdeStatusBarImpl statusBar = Objects.requireNonNull(this.getStatusBar());
        statusBar.addWidget((StatusBarWidget)new LightEditPositionWidget(editorManager), StatusBar.Anchors.before((String)"FatalError"), this);
        statusBar.addWidget((StatusBarWidget)new LightEditAutosaveWidget(editorManager), StatusBar.Anchors.before((String)"FatalError"), this);
        statusBar.addWidget((StatusBarWidget)new LightEditEncodingWidgetWrapper(), StatusBar.Anchors.after((String)"Position"), this);
        statusBar.addWidget((StatusBarWidget)new LightEditLineSeparatorWidgetWrapper(), StatusBar.Anchors.before((String)"light.edit.encoding.widget"), this);
        PopupHandler.installPopupHandler((JComponent)statusBar, (String)"ViewStatusBarWidgetsGroup", (String)"StatusBarPlace");
        StatusBarWidgetsManager statusBarWidgetsManager = (StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class));
        ApplicationManager.getApplication().invokeLater(() -> statusBarWidgetsManager.updateAllWidgets());
        Disposer.register((Disposable)statusBar, () -> statusBarWidgetsManager.disableAllWidgets());
    }

    @Override
    protected void initTitleInfoProviders(@NotNull Project project) {
    }

    @Override
    @NotNull
    protected CloseProjectWindowHelper createCloseProjectWindowHelper() {
        return new CloseProjectWindowHelper(){

            @Override
            public void windowClosing(@Nullable Project project) {
                if (LightEditFrameWrapper.this.myCloseHandler.getAsBoolean()) {
                    super.windowClosing(project);
                }
            }
        };
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.myEditPanel);
    }

    @NotNull
    static LightEditFrameWrapper allocate(@NotNull BooleanSupplier closeHandler) {
        return (LightEditFrameWrapper)((WindowManagerImpl)WindowManager.getInstance()).allocateFrame(LightEditUtil.getProject(), () -> new LightEditFrameWrapper(ProjectFrameAllocatorKt.createNewProjectFrame(false), closeHandler));
    }

    private class LightEditRootPane
    extends IdeRootPane {
        LightEditRootPane(@NotNull JFrame frame, @NotNull IdeFrame frameHelper, Disposable parentDisposable) {
            super(frame, frameHelper, parentDisposable);
        }

        @Override
        @NotNull
        protected Component getCenterComponent(@NotNull JFrame frame, @NotNull Disposable parentDisposable) {
            LightEditFrameWrapper.this.myEditPanel = new LightEditPanel();
            return LightEditFrameWrapper.this.myEditPanel;
        }

        @Override
        @NotNull
        public ToolWindowsPane getToolWindowPane() {
            throw new IllegalStateException("Tool windows are unavailable in LightEdit");
        }

        @Override
        @NotNull
        protected IdeMenuBar createMenuBar() {
            return new LightEditMenuBar();
        }

        @Override
        @NotNull
        protected IdeStatusBarImpl createStatusBar(@NotNull IdeFrame frame) {
            return new IdeStatusBarImpl(frame, false);
        }

        @Override
        protected void updateNorthComponents() {
        }

        @Override
        protected void installNorthComponents(@NotNull Project project) {
        }

        @Override
        protected void deinstallNorthComponents() {
        }
    }
}

