/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeOverrider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.CachedFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightEditFileTypeOverrider
implements FileTypeOverrider {
    private static final Key<Boolean> KEY = Key.create((String)"LightEdit.PlainText");

    @Override
    @Nullable
    public FileType getOverriddenFileType(@NotNull VirtualFile file2) {
        return LightEditFileTypeOverrider.isPlainText(file2) ? PlainTextFileType.INSTANCE : null;
    }

    private static boolean isPlainText(@NotNull VirtualFile file2) {
        return file2.getUserData(KEY) == Boolean.TRUE;
    }

    static void markUnknownFileTypeAsPlainText(@NotNull VirtualFile file2) {
        if (file2.getFileType() == FileTypes.UNKNOWN) {
            file2.putUserData(KEY, (Object)Boolean.TRUE);
            CachedFileType.clearCache();
        }
    }
}

