/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.actions;

import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BrowseHierarchyActionBase
extends AnAction {
    private static final Logger LOG = Logger.getInstance(BrowseHierarchyActionBase.class);
    private final LanguageExtension<HierarchyProvider> myExtension;

    protected BrowseHierarchyActionBase(@NotNull LanguageExtension<HierarchyProvider> extension) {
        this.myExtension = extension;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        HierarchyProvider provider = this.getProvider(e);
        if (provider == null) {
            return;
        }
        PsiElement target2 = provider.getTarget(dataContext);
        if (target2 == null) {
            return;
        }
        BrowseHierarchyActionBase.createAndAddToPanel(project, provider, target2);
    }

    @NotNull
    public static HierarchyBrowser createAndAddToPanel(@NotNull Project project, @NotNull HierarchyProvider provider, @NotNull PsiElement target2) {
        Content content2;
        HierarchyBrowser hierarchyBrowser = provider.createHierarchyBrowser(target2);
        HierarchyBrowserManager hierarchyBrowserManager = HierarchyBrowserManager.getInstance(project);
        ContentManager contentManager2 = hierarchyBrowserManager.getContentManager();
        Content selectedContent = contentManager2.getSelectedContent();
        JComponent browserComponent = hierarchyBrowser.getComponent();
        if (!DumbService.isDumbAware((Object)hierarchyBrowser)) {
            browserComponent = DumbService.getInstance((Project)project).wrapGently(browserComponent, (Disposable)project);
        }
        if (selectedContent != null && !selectedContent.isPinned()) {
            content2 = selectedContent;
            JComponent component2 = content2.getComponent();
            if (component2 instanceof DumbUnawareHider) {
                component2 = ((DumbUnawareHider)component2).getContent();
            }
            if (component2 instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)component2));
            }
            content2.setComponent(browserComponent);
        } else {
            content2 = ContentFactory.SERVICE.getInstance().createContent(browserComponent, null, true);
            contentManager2.addContent(content2);
        }
        content2.setHelpId("reference.toolWindows.hierarchy");
        contentManager2.setSelectedContent(content2);
        hierarchyBrowser.setContent(content2);
        Runnable runnable2 = () -> {
            if (hierarchyBrowser instanceof HierarchyBrowserBase && ((HierarchyBrowserBase)hierarchyBrowser).isDisposed()) {
                return;
            }
            provider.browserActivated(hierarchyBrowser);
        };
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Hierarchy");
        toolWindow.activate(runnable2);
        if (hierarchyBrowser instanceof Disposable) {
            Disposer.register((Disposable)toolWindow.getContentManager(), (Disposable)((Disposable)hierarchyBrowser));
        }
        return hierarchyBrowser;
    }

    public void update(@NotNull AnActionEvent e) {
        if (!this.myExtension.hasAnyExtensions()) {
            e.getPresentation().setVisible(false);
        } else {
            boolean enabled = this.isEnabled(e);
            if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
                e.getPresentation().setVisible(enabled);
            } else {
                e.getPresentation().setVisible(true);
            }
            e.getPresentation().setEnabled(enabled);
        }
    }

    private boolean isEnabled(AnActionEvent e) {
        HierarchyProvider provider = this.getProvider(e);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using provider " + provider);
        }
        if (provider == null) {
            return false;
        }
        PsiElement target2 = provider.getTarget(e.getDataContext());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Target: " + target2);
        }
        return target2 != null;
    }

    @Nullable
    private HierarchyProvider getProvider(AnActionEvent e) {
        return BrowseHierarchyActionBase.findProvider(this.myExtension, (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT), (PsiFile)e.getData(CommonDataKeys.PSI_FILE), e.getDataContext());
    }

    @Nullable
    public static HierarchyProvider findProvider(@NotNull LanguageExtension<HierarchyProvider> extension, @Nullable PsiElement psiElement, @Nullable PsiFile psiFile, @NotNull DataContext dataContext) {
        HierarchyProvider provider = BrowseHierarchyActionBase.findBestHierarchyProvider(extension, psiElement, dataContext);
        if (provider == null) {
            return BrowseHierarchyActionBase.findBestHierarchyProvider(extension, (PsiElement)psiFile, dataContext);
        }
        return provider;
    }

    @Nullable
    public static HierarchyProvider findBestHierarchyProvider(LanguageExtension<HierarchyProvider> extension, @Nullable PsiElement element2, DataContext dataContext) {
        if (element2 == null) {
            return null;
        }
        List providers = extension.allForLanguage(element2.getLanguage());
        for (HierarchyProvider provider : providers) {
            PsiElement target2 = provider.getTarget(dataContext);
            if (target2 == null) continue;
            return provider;
        }
        return (HierarchyProvider)ContainerUtil.getFirstItem((List)providers);
    }
}

