/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateLoadResult;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.project.ProjectKt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashSet;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.velocity.runtime.ParserPool;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.directive.Stop;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileTemplatesLoader
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FileTemplatesLoader.class);
    static final String TEMPLATES_DIR = "fileTemplates";
    private static final String DEFAULT_TEMPLATES_ROOT = "fileTemplates";
    private static final String DESCRIPTION_FILE_EXTENSION = "html";
    private static final String DESCRIPTION_EXTENSION_SUFFIX = ".html";
    private static final Map<String, String> MANAGER_TO_DIR = ContainerUtil.newHashMap((Pair)Pair.create((Object)"Default", (Object)""), (Pair[])new Pair[]{Pair.create((Object)"Internal", (Object)"internal"), Pair.create((Object)"Includes", (Object)"includes"), Pair.create((Object)"Code", (Object)"code"), Pair.create((Object)"J2EE", (Object)"j2ee")});
    private final ClearableLazyValue<LoadedConfiguration> myManagers = ClearableLazyValue.createAtomic(() -> FileTemplatesLoader.loadConfiguration(project));

    FileTemplatesLoader(@Nullable Project project) {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                this.clearClassLeakViaStaticExceptionTrace();
                this.resetParserPool();
            }

            private void clearClassLeakViaStaticExceptionTrace() {
                Field field = ReflectionUtil.getDeclaredField(Stop.class, (String)"STOP_ALL");
                if (field != null) {
                    try {
                        ThrowableInterner.clearBacktrace((Throwable)((Throwable)field.get(null)));
                    }
                    catch (Throwable e) {
                        LOG.info(e);
                    }
                }
            }

            private void resetParserPool() {
                try {
                    Object pp;
                    RuntimeServices ri = RuntimeSingleton.getRuntimeServices();
                    Field ppField = ReflectionUtil.getDeclaredField(ri.getClass(), (String)"parserPool");
                    if (ppField != null && (pp = ppField.get(ri)) instanceof ParserPool) {
                        ((ParserPool)pp).initialize(ri);
                    }
                }
                catch (Throwable e) {
                    LOG.info(e);
                }
            }

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                FileTemplatesLoader.this.myManagers.drop();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                FileTemplatesLoader.this.myManagers.drop();
            }
        });
    }

    public void dispose() {
    }

    @NotNull
    @NotNull Collection<@NotNull FTManager> getAllManagers() {
        return ((LoadedConfiguration)this.myManagers.getValue()).getManagers();
    }

    @NotNull
    FTManager getDefaultTemplatesManager() {
        return new FTManager(((LoadedConfiguration)this.myManagers.getValue()).getManager("Default"));
    }

    @NotNull
    FTManager getInternalTemplatesManager() {
        return new FTManager(((LoadedConfiguration)this.myManagers.getValue()).getManager("Internal"));
    }

    @NotNull
    FTManager getPatternsManager() {
        return new FTManager(((LoadedConfiguration)this.myManagers.getValue()).getManager("Includes"));
    }

    @NotNull
    FTManager getCodeTemplatesManager() {
        return new FTManager(((LoadedConfiguration)this.myManagers.getValue()).getManager("Code"));
    }

    @NotNull
    FTManager getJ2eeTemplatesManager() {
        return new FTManager(((LoadedConfiguration)this.myManagers.getValue()).getManager("J2EE"));
    }

    URL getDefaultTemplateDescription() {
        return ((LoadedConfiguration)this.myManagers.getValue()).defaultTemplateDescription;
    }

    URL getDefaultIncludeDescription() {
        return ((LoadedConfiguration)this.myManagers.getValue()).defaultIncludeDescription;
    }

    private static LoadedConfiguration loadConfiguration(@Nullable Project project) {
        Path configDir;
        if (project == null || project.isDefault()) {
            configDir = PathManager.getConfigDir().resolve("fileTemplates");
        } else {
            String storeDirPath = Objects.requireNonNull(ProjectKt.getStateStore(project).getDirectoryStorePath(true));
            configDir = Paths.get(storeDirPath, "fileTemplates");
        }
        FileTemplateLoadResult result2 = FileTemplatesLoader.loadDefaultTemplates(new ArrayList<String>(MANAGER_TO_DIR.values()));
        HashMap<String, FTManager> managers = new HashMap<String, FTManager>();
        for (Map.Entry<String, String> entry : MANAGER_TO_DIR.entrySet()) {
            String name = entry.getKey();
            String pathPrefix = entry.getValue();
            FTManager manager = new FTManager(name, configDir.resolve(pathPrefix), name.equals("Internal"));
            manager.setDefaultTemplates(result2.getResult().get((Object)pathPrefix));
            manager.loadCustomizedContent();
            managers.put(name, manager);
        }
        return new LoadedConfiguration(managers, result2.getDefaultTemplateDescription(), result2.getDefaultIncludeDescription());
    }

    @NotNull
    private static FileTemplateLoadResult loadDefaultTemplates(@NotNull List<String> prefixes) {
        IdeaPluginDescriptor[] plugins;
        FileTemplateLoadResult result2 = new FileTemplateLoadResult((MultiMap<String, DefaultTemplate>)new MultiMap());
        THashSet processedUrls = new THashSet();
        HashSet<ClassLoader> processedLoaders = new HashSet<ClassLoader>();
        for (IdeaPluginDescriptor plugin : plugins = PluginManagerCore.getPlugins()) {
            ClassLoader loader;
            if (!(plugin instanceof IdeaPluginDescriptorImpl) || !plugin.isEnabled() || (loader = plugin.getPluginClassLoader()) instanceof PluginClassLoader && ((PluginClassLoader)((Object)loader)).getUrls().isEmpty() || !processedLoaders.add(loader)) continue;
            try {
                Enumeration<URL> systemResources = loader.getResources("fileTemplates");
                if (!systemResources.hasMoreElements()) continue;
                while (systemResources.hasMoreElements()) {
                    URL url = systemResources.nextElement();
                    if (!processedUrls.add(url)) continue;
                    FileTemplatesLoader.loadDefaultsFromRoot(url, prefixes, result2);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return result2;
    }

    private static void loadDefaultsFromRoot(@NotNull URL root, @NotNull List<String> prefixes, @NotNull FileTemplateLoadResult result2) throws IOException {
        List<String> children2 = UrlUtil.getChildrenRelativePaths(root);
        if (children2.isEmpty()) {
            return;
        }
        HashSet<String> descriptionPaths = new HashSet<String>();
        for (String path : children2) {
            if (path.equals("default.html")) {
                result2.setDefaultTemplateDescription(UrlClassLoader.internProtocol((URL)new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + path)));
                continue;
            }
            if (path.equals("includes/default.html")) {
                result2.setDefaultIncludeDescription(UrlClassLoader.internProtocol((URL)new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + path)));
                continue;
            }
            if (!path.endsWith(DESCRIPTION_EXTENSION_SUFFIX)) continue;
            descriptionPaths.add(path);
        }
        block1: for (String path : children2) {
            if (!path.endsWith(".ft")) continue;
            for (String prefix : prefixes) {
                URL descriptionUrl;
                if (!FileTemplatesLoader.matchesPrefix(path, prefix)) continue;
                String filename = path.substring(prefix.isEmpty() ? 0 : prefix.length() + 1, path.length() - ".ft".length());
                String extension = FileUtilRt.getExtension((String)filename);
                String templateName = filename.substring(0, filename.length() - extension.length() - 1);
                URL templateUrl = UrlClassLoader.internProtocol((URL)new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + path));
                String descriptionPath = FileTemplatesLoader.getDescriptionPath(prefix, templateName, extension, descriptionPaths);
                URL uRL = descriptionUrl = descriptionPath == null ? null : UrlClassLoader.internProtocol((URL)new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + descriptionPath));
                assert (templateUrl != null);
                result2.getResult().putValue((Object)prefix, (Object)new DefaultTemplate(templateName, extension, templateUrl, descriptionUrl));
                continue block1;
            }
        }
    }

    private static boolean matchesPrefix(@NotNull String path, @NotNull String prefix) {
        if (prefix.isEmpty()) {
            return path.indexOf(47) == -1;
        }
        return FileUtil.startsWith((String)path, (String)prefix) && path.indexOf(47, prefix.length() + 1) == -1;
    }

    @Nullable
    private static String getDescriptionPath(@NotNull String pathPrefix, @NotNull String templateName, @NotNull String templateExtension, @NotNull Set<String> descriptionPaths) {
        String descPath;
        Locale locale = Locale.getDefault();
        String descName = MessageFormat.format("{0}.{1}_{2}_{3}.html", templateName, templateExtension, locale.getLanguage(), locale.getCountry());
        String string = descPath = pathPrefix.isEmpty() ? descName : pathPrefix + "/" + descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        descName = MessageFormat.format("{0}.{1}_{2}.html", templateName, templateExtension, locale.getLanguage());
        String string2 = descPath = pathPrefix.isEmpty() ? descName : pathPrefix + descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        descName = templateName + "." + templateExtension + DESCRIPTION_EXTENSION_SUFFIX;
        String string3 = descPath = pathPrefix.isEmpty() ? descName : pathPrefix + descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        return null;
    }

    private static class LoadedConfiguration {
        public final URL defaultTemplateDescription;
        public final URL defaultIncludeDescription;
        private final Map<String, FTManager> myManagers;

        LoadedConfiguration(@NotNull Map<String, FTManager> managers, URL defaultTemplateDescription, URL defaultIncludeDescription) {
            this.myManagers = Collections.unmodifiableMap(managers);
            this.defaultTemplateDescription = defaultTemplateDescription;
            this.defaultIncludeDescription = defaultIncludeDescription;
        }

        public FTManager getManager(@NotNull String kind) {
            return this.myManagers.get(kind);
        }

        public Collection<FTManager> getManagers() {
            return this.myManagers.values();
        }
    }
}

