/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.actions;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFromTemplateAction
extends CreateFromTemplateActionBase {
    private final Supplier<? extends FileTemplate> myTemplate;

    public CreateFromTemplateAction(@NotNull FileTemplate template) {
        this(template.getName(), FileTemplateUtil.getIcon(template), () -> template);
    }

    public CreateFromTemplateAction(String templateName, @Nullable Icon icon2, @NotNull Supplier<? extends FileTemplate> template) {
        super(templateName, null, icon2);
        this.myTemplate = template;
    }

    @Override
    protected FileTemplate getTemplate(Project project, PsiDirectory dir) {
        return this.myTemplate.get();
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Presentation presentation2 = e.getPresentation();
        boolean isEnabled = CreateFromTemplateGroup.canCreateFromTemplate(e, this.myTemplate.get());
        presentation2.setEnabledAndVisible(isEnabled);
    }

    @NotNull
    public FileTemplate getTemplate() {
        return this.myTemplate.get();
    }
}

