/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.actions;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributesDefaults {
    private final String myDefaultName;
    private final TextRange myDefaultRange;
    private final Map<String, Pair<String, TextRange>> myNamesToValueAndRangeMap = new HashMap<String, Pair<String, TextRange>>();
    private Properties myDefaultProperties = null;
    private boolean myFixedName;

    public AttributesDefaults() {
        this(null, null);
    }

    public AttributesDefaults(@Nullable String defaultName) {
        this(defaultName, null);
    }

    public AttributesDefaults(@Nullable String defaultName, @Nullable TextRange defaultRange) {
        this.myDefaultName = defaultName;
        this.myDefaultRange = defaultRange;
    }

    @Nullable
    public String getDefaultFileName() {
        return this.myDefaultName;
    }

    @Nullable
    public TextRange getDefaultFileNameSelection() {
        return this.myDefaultRange;
    }

    public void add(@NotNull String attributeKey, @NotNull String value2) {
        this.add(attributeKey, value2, null);
    }

    public void add(@NotNull String attributeKey, @NotNull String value2, @Nullable TextRange selectionRange) {
        this.myNamesToValueAndRangeMap.put(attributeKey, (Pair<String, TextRange>)Pair.pair((Object)value2, (Object)selectionRange));
    }

    public void addPredefined(@NotNull String key, @NotNull String value2) {
        if (this.myDefaultProperties == null) {
            this.myDefaultProperties = new Properties();
        }
        this.myDefaultProperties.setProperty(key, value2);
    }

    public Properties getDefaultProperties() {
        return this.myDefaultProperties;
    }

    @Nullable
    public TextRange getRangeFor(@NotNull String attributeKey) {
        Pair<String, TextRange> valueAndRange = this.myNamesToValueAndRangeMap.get(attributeKey);
        return (TextRange)Pair.getSecond(valueAndRange);
    }

    @Nullable
    public String getDefaultValueFor(@NotNull String attributeKey) {
        Pair<String, TextRange> valueAndRange = this.myNamesToValueAndRangeMap.get(attributeKey);
        return (String)Pair.getFirst(valueAndRange);
    }

    public boolean isFixedName() {
        return this.myFixedName;
    }

    public AttributesDefaults withFixedName(boolean fixedName) {
        this.myFixedName = fixedName;
        return this;
    }
}

