/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoriteTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ui.treeStructure.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FavoritesTreeUtil {
    public static FavoriteTreeNodeDescriptor @NotNull [] getSelectedNodeDescriptors(DnDAwareTree tree) {
        TreePath[] path = tree.getSelectionPaths();
        if (path == null) {
            return FavoriteTreeNodeDescriptor.EMPTY_ARRAY;
        }
        ArrayList<FavoriteTreeNodeDescriptor> result2 = new ArrayList<FavoriteTreeNodeDescriptor>();
        for (TreePath treePath : path) {
            DefaultMutableTreeNode lastPathNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object userObject = lastPathNode.getUserObject();
            if (!(userObject instanceof FavoriteTreeNodeDescriptor)) continue;
            FavoriteTreeNodeDescriptor treeNodeDescriptor = (FavoriteTreeNodeDescriptor)((Object)userObject);
            result2.add(treeNodeDescriptor);
        }
        return result2.toArray(FavoriteTreeNodeDescriptor.EMPTY_ARRAY);
    }

    public static List<AbstractTreeNode<?>> getLogicalPathToSelected(Tree tree) {
        ArrayList result2 = new ArrayList();
        TreePath selectionPath = tree.getSelectionPath();
        return FavoritesTreeUtil.getLogicalPathTo(result2, selectionPath);
    }

    public static List<AbstractTreeNode<?>> getLogicalPathTo(List<AbstractTreeNode<?>> result2, TreePath selectionPath) {
        Object uo;
        Object component2 = selectionPath.getLastPathComponent();
        if (component2 instanceof DefaultMutableTreeNode && (uo = ((DefaultMutableTreeNode)component2).getUserObject()) instanceof FavoriteTreeNodeDescriptor) {
            for (AbstractTreeNode treeNode = ((FavoriteTreeNodeDescriptor)((Object)uo)).getElement(); !(treeNode instanceof FavoritesListNode) && treeNode != null; treeNode = treeNode.getParent()) {
                result2.add(treeNode);
            }
            Collections.reverse(result2);
            return result2;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static FavoritesListNode extractParentList(FavoriteTreeNodeDescriptor descriptor2) {
        for (AbstractTreeNode current2 = descriptor2.getElement(); current2 != null; current2 = current2.getParent()) {
            if (!(current2 instanceof FavoritesListNode)) continue;
            return (FavoritesListNode)current2;
        }
        return null;
    }

    static FavoritesListProvider getProvider(@NotNull FavoritesManager manager, @NotNull FavoriteTreeNodeDescriptor descriptor2) {
        AbstractTreeNode treeNode;
        for (treeNode = descriptor2.getElement(); treeNode != null && !(treeNode instanceof FavoritesListNode); treeNode = treeNode.getParent()) {
        }
        if (treeNode != null) {
            String name = (String)((FavoritesListNode)treeNode).getValue();
            return manager.getListProvider(name);
        }
        return null;
    }
}

