/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoriteTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesRootNode;
import com.intellij.ide.projectView.SettingsProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class FavoritesTreeStructure
extends ProjectTreeStructure {
    private static final Logger LOGGER = Logger.getInstance(FavoritesTreeStructure.class);
    private final TreeStructureProvider myNonProjectProvider;

    public FavoritesTreeStructure(@NotNull Project project) {
        super(project, "Favorites");
        this.myNonProjectProvider = new MyProvider(project);
    }

    protected AbstractTreeNode<?> createRoot(@NotNull Project project, @NotNull ViewSettings settings) {
        return new FavoritesRootNode(project);
    }

    public void rootsChanged() {
        ((FavoritesRootNode)((Object)this.getRootElement())).rootsChanged();
    }

    @Override
    public Object @NotNull [] getChildElements(@NotNull Object element2) {
        if (!(element2 instanceof AbstractTreeNode)) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        AbstractTreeNode favTreeElement = (AbstractTreeNode)element2;
        try {
            if (!(element2 instanceof FavoritesListNode)) {
                Object[] elements2 = super.getChildElements(favTreeElement);
                if (elements2.length > 0) {
                    return elements2;
                }
                ViewSettings settings = favTreeElement instanceof SettingsProvider ? ((SettingsProvider)favTreeElement).getSettings() : ViewSettings.DEFAULT;
                return ArrayUtil.toObjectArray((Collection)this.myNonProjectProvider.modify(favTreeElement, new ArrayList(), settings));
            }
            ArrayList result2 = new ArrayList();
            FavoritesListNode listNode = (FavoritesListNode)((Object)element2);
            if (listNode.getProvider() != null) {
                return ArrayUtil.toObjectArray(listNode.getChildren());
            }
            Collection<AbstractTreeNode<?>> roots = FavoritesListNode.getFavoritesRoots(this.myProject, listNode.getName(), listNode);
            for (AbstractTreeNode<?> abstractTreeNode : roots) {
                Object value2 = abstractTreeNode.getValue();
                if (value2 == null || value2 instanceof PsiElement && !((PsiElement)value2).isValid() || value2 instanceof SmartPsiElementPointer && ((SmartPsiElementPointer)value2).getElement() == null) continue;
                boolean invalid = false;
                for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])FavoriteNodeProvider.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
                    if (!nodeProvider.isInvalidElement(value2)) continue;
                    invalid = true;
                    break;
                }
                if (invalid) continue;
                result2.add(abstractTreeNode);
            }
            return ArrayUtil.toObjectArray(result2);
        }
        catch (ProcessCanceledException result2) {
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public Object getParentElement(@NotNull Object element2) {
        AbstractTreeNode parent = null;
        if (element2 == this.getRootElement()) {
            return null;
        }
        if (element2 instanceof AbstractTreeNode) {
            parent = ((AbstractTreeNode)element2).getParent();
        }
        if (parent == null) {
            return this.getRootElement();
        }
        return parent;
    }

    @Override
    @NotNull
    public NodeDescriptor<?> createDescriptor(@NotNull Object element2, NodeDescriptor parentDescriptor) {
        return new FavoriteTreeNodeDescriptor(this.myProject, parentDescriptor, (AbstractTreeNode)element2);
    }

    private static class MyProvider
    implements TreeStructureProvider {
        private final Project myProject;

        MyProvider(Project project) {
            this.myProject = project;
        }

        @NotNull
        public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children2, ViewSettings settings) {
            if (parent instanceof PsiDirectoryNode && children2.isEmpty()) {
                VirtualFile virtualFile = ((PsiDirectoryNode)parent).getVirtualFile();
                if (virtualFile == null) {
                    return children2;
                }
                VirtualFile[] virtualFiles = virtualFile.getChildren();
                ArrayList result2 = new ArrayList();
                PsiManagerImpl psiManager = (PsiManagerImpl)PsiManager.getInstance((Project)this.myProject);
                for (VirtualFile file2 : virtualFiles) {
                    BasePsiNode child2;
                    if (file2.isDirectory()) {
                        PsiDirectory directory = psiManager.findDirectory(file2);
                        if (directory == null) continue;
                        child2 = new PsiDirectoryNode(this.myProject, directory, settings);
                    } else {
                        PsiFile psiFile = psiManager.findFile(file2);
                        if (psiFile == null) continue;
                        child2 = new PsiFileNode(this.myProject, psiFile, settings);
                    }
                    child2.setParent(parent);
                    result2.add((AbstractTreeNode<?>)child2);
                }
                return result2;
            }
            return children2;
        }
    }
}

