/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.externalComponents;

import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalComponentManager {
    @NotNull
    public static ExternalComponentManager getInstance() {
        return (ExternalComponentManager)ServiceManager.getService(ExternalComponentManager.class);
    }

    @NotNull
    public Iterable<ExternalComponentSource> getEnabledComponentSources(@NotNull UpdateSettings updateSettings) {
        this.refreshKnownSources(updateSettings);
        HashSet<String> enabledSources = new HashSet<String>(updateSettings.getEnabledExternalUpdateSources());
        LinkedList<ExternalComponentSource> res2 = new LinkedList<ExternalComponentSource>(ExternalComponentSource.EP_NAME.getExtensionList());
        res2.removeIf(source -> !enabledSources.contains(source.getName()));
        return res2;
    }

    private void refreshKnownSources(@NotNull UpdateSettings updateSettings) {
        LinkedList<ExternalComponentSource> unknownSources = new LinkedList<ExternalComponentSource>(ExternalComponentSource.EP_NAME.getExtensionList());
        HashSet<String> knownSources = new HashSet<String>(updateSettings.getKnownExternalUpdateSources());
        unknownSources.removeIf(source -> knownSources.contains(source.getName()));
        for (ExternalComponentSource source2 : unknownSources) {
            updateSettings.getKnownExternalUpdateSources().add(source2.getName());
            updateSettings.getEnabledExternalUpdateSources().add(source2.getName());
            List<String> channels = source2.getAllChannels();
            if (channels == null) continue;
            updateSettings.getExternalUpdateChannels().put(source2.getName(), channels.get(0));
        }
    }

    @Nullable
    public UpdatableExternalComponent findExistingComponentMatching(@NotNull UpdatableExternalComponent update2, @NotNull ExternalComponentSource source) {
        Collection<UpdatableExternalComponent> existing = source.getCurrentVersions();
        for (UpdatableExternalComponent c : existing) {
            if (!update2.isUpdateFor(c)) continue;
            return c;
        }
        return null;
    }
}

