/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.ide.errorTreeView.CallingBackColoredTreeCellRenderer;
import com.intellij.ide.errorTreeView.CustomizeColoredTreeCellRendererReplacement;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.ClickableTreeCellRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TreeNodePartListener;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.MultilineTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AbstractAccessibleContextDelegate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewErrorTreeRenderer
extends MultilineTreeCellRenderer {
    private final MyWrapperRenderer myWrapperRenderer;
    private final CallingBackColoredTreeCellRenderer myColoredTreeCellRenderer = new CallingBackColoredTreeCellRenderer();
    private final MyNotSelectedColoredTreeCellRenderer myRightCellRenderer = new MyNotSelectedColoredTreeCellRenderer();

    private NewErrorTreeRenderer() {
        this.myWrapperRenderer = new MyWrapperRenderer((TreeCellRenderer)((Object)this.myColoredTreeCellRenderer), this.myRightCellRenderer);
    }

    public static JScrollPane install(JTree tree) {
        NewErrorTreeRenderer renderer = new NewErrorTreeRenderer();
        new TreeNodePartListener(renderer.myRightCellRenderer).installOn(tree);
        return MultilineTreeCellRenderer.installRenderer(tree, renderer);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ErrorTreeElement element2 = NewErrorTreeRenderer.getElement(value2);
        if (element2 != null) {
            CustomizeColoredTreeCellRenderer leftSelfRenderer = element2.getLeftSelfRenderer();
            CustomizeColoredTreeCellRenderer rightSelfRenderer = element2.getRightSelfRenderer();
            if (leftSelfRenderer != null || rightSelfRenderer != null) {
                this.myColoredTreeCellRenderer.setCurrentCallback(leftSelfRenderer);
                this.myRightCellRenderer.setCurrentCallback(rightSelfRenderer);
                return this.myWrapperRenderer.getTreeCellRendererComponent(tree, value2, selected2, expanded, leaf, row, hasFocus);
            }
        }
        return super.getTreeCellRendererComponent(tree, value2, selected2, expanded, leaf, row, hasFocus);
    }

    @NotNull
    public static String calcPrefix(@Nullable ErrorTreeElement element2) {
        if (element2 instanceof SimpleMessageElement || element2 instanceof NavigatableMessageElement) {
            String rendPrefix;
            String prefix = element2.getPresentableText();
            if (element2 instanceof NavigatableMessageElement && !StringUtil.isEmpty((String)(rendPrefix = ((NavigatableMessageElement)element2).getRendererTextPrefix()))) {
                prefix = prefix + rendPrefix + " ";
            }
            return prefix;
        }
        return "";
    }

    @Override
    protected void initComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ErrorTreeElement element2 = NewErrorTreeRenderer.getElement(value2);
        if (element2 instanceof GroupingElement && ((GroupingElement)element2).isRenderWithBoldFont()) {
            this.setFont(this.getFont().deriveFont(1));
        }
        String prefix = NewErrorTreeRenderer.calcPrefix(element2);
        if (element2 != null) {
            String[] text = element2.getText();
            if (text == null) {
                text = ArrayUtilRt.EMPTY_STRING_ARRAY;
            }
            if (text.length > 0 && text[0] == null) {
                text[0] = "";
            }
            this.setText(text, prefix);
            this.setIcon(element2.getIcon());
        }
    }

    private static ErrorTreeElement getElement(Object value2) {
        if (!(value2 instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
        if (!(userObject instanceof ErrorTreeNodeDescriptor)) {
            return null;
        }
        return ((ErrorTreeNodeDescriptor)((Object)userObject)).getElement();
    }

    private static class MyWrapperRenderer
    implements TreeCellRenderer {
        private final TreeCellRenderer myLeft;
        private final TreeCellRenderer myRight;
        private final MyPanel myPanel;

        public TreeCellRenderer getLeft() {
            return this.myLeft;
        }

        public TreeCellRenderer getRight() {
            return this.myRight;
        }

        MyWrapperRenderer(TreeCellRenderer left, TreeCellRenderer right) {
            this.myLeft = left;
            this.myRight = right;
            this.myPanel = new MyPanel(new BorderLayout());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.myPanel.removeAll();
            this.myPanel.setBackground(RenderingUtil.getBackground((JTree)tree));
            this.myPanel.add(this.myLeft.getTreeCellRendererComponent(tree, value2, selected2, expanded, leaf, row, hasFocus), "West");
            this.myPanel.add(this.myRight.getTreeCellRendererComponent(tree, value2, selected2, expanded, leaf, row, hasFocus), "East");
            return this.myPanel;
        }

        private class MyPanel
        extends JPanel
        implements Accessible {
            private AccessibleContext myDefaultAccessibleContext;

            MyPanel(LayoutManager layout) {
                super(layout);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleMyPanel();
                }
                return this.accessibleContext;
            }

            private AccessibleContext getDefaultAccessibleContext() {
                if (this.myDefaultAccessibleContext == null) {
                    this.myDefaultAccessibleContext = super.getAccessibleContext();
                }
                return this.myDefaultAccessibleContext;
            }

            protected class AccessibleMyPanel
            extends AbstractAccessibleContextDelegate {
                protected AccessibleMyPanel() {
                }

                @NotNull
                protected AccessibleContext getDelegate() {
                    Component c;
                    if (MyWrapperRenderer.this.myPanel.getComponentCount() >= 2 && (c = MyWrapperRenderer.this.myPanel.getComponent(1)) instanceof Accessible) {
                        return c.getAccessibleContext();
                    }
                    return MyPanel.this.getDefaultAccessibleContext();
                }

                public String getAccessibleName() {
                    String name = StringUtil.join((Object[])MyPanel.this.getComponents(), c -> {
                        if (c instanceof Accessible) {
                            return c.getAccessibleContext().getAccessibleName();
                        }
                        return null;
                    }, (String)" ");
                    if (StringUtil.isEmpty((String)name)) {
                        name = MyPanel.this.getDefaultAccessibleContext().getAccessibleName();
                    }
                    return name;
                }
            }
        }
    }

    private static class MyNotSelectedColoredTreeCellRenderer
    extends SimpleColoredComponent
    implements ClickableTreeCellRenderer {
        private CustomizeColoredTreeCellRenderer myCurrentCallback;

        private MyNotSelectedColoredTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (this.myCurrentCallback instanceof CustomizeColoredTreeCellRendererReplacement) {
                return ((CustomizeColoredTreeCellRendererReplacement)this.myCurrentCallback).getTreeCellRendererComponent(tree, value2, selected2, expanded, leaf, row, hasFocus);
            }
            this.clear();
            this.setBackground(UIUtil.getBgFillColor((Component)tree));
            if (this.myCurrentCallback != null) {
                this.myCurrentCallback.customizeCellRenderer((SimpleColoredComponent)this, tree, value2, selected2, expanded, leaf, row, hasFocus);
            }
            if (this.getFont() == null) {
                this.setFont(tree.getFont());
            }
            return this;
        }

        @Override
        @Nullable
        public Object getTag() {
            return this.myCurrentCallback == null ? null : this.myCurrentCallback.getTag();
        }

        public void setCurrentCallback(CustomizeColoredTreeCellRenderer currentCallback) {
            this.myCurrentCallback = currentCallback;
        }
    }
}

