/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.LinuxDragAndDropSupport;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileCopyPasteUtil {
    private static final Logger LOG = Logger.getInstance(FileCopyPasteUtil.class);

    private FileCopyPasteUtil() {
    }

    public static DataFlavor createDataFlavor(@NotNull String mimeType) {
        return FileCopyPasteUtil.createDataFlavor(mimeType, null, false);
    }

    public static DataFlavor createDataFlavor(@NotNull String mimeType, @Nullable Class<?> klass) {
        return FileCopyPasteUtil.createDataFlavor(mimeType, klass, false);
    }

    public static DataFlavor createDataFlavor(@NotNull String mimeType, @Nullable Class<?> klass, boolean register2) {
        try {
            FlavorMap map2;
            DataFlavor flavor;
            DataFlavor dataFlavor = flavor = klass != null ? new DataFlavor(mimeType + ";class=" + klass.getName(), null, klass.getClassLoader()) : new DataFlavor(mimeType);
            if (register2 && (map2 = SystemFlavorMap.getDefaultFlavorMap()) instanceof SystemFlavorMap) {
                ((SystemFlavorMap)map2).addUnencodedNativeForFlavor(flavor, mimeType);
            }
            return flavor;
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static DataFlavor createJvmDataFlavor(@NotNull Class<?> klass) {
        return FileCopyPasteUtil.createDataFlavor("application/x-java-jvm-local-objectref", klass, false);
    }

    public static boolean isFileListFlavorAvailable() {
        return CopyPasteManager.getInstance().areDataFlavorsAvailable(new DataFlavor[]{DataFlavor.javaFileListFlavor, LinuxDragAndDropSupport.uriListFlavor, LinuxDragAndDropSupport.gnomeFileListFlavor});
    }

    public static boolean isFileListFlavorAvailable(@NotNull DnDEvent event) {
        return event.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || event.isDataFlavorSupported(LinuxDragAndDropSupport.uriListFlavor) || event.isDataFlavorSupported(LinuxDragAndDropSupport.gnomeFileListFlavor);
    }

    public static boolean isFileListFlavorAvailable(DataFlavor @NotNull [] transferFlavors) {
        for (DataFlavor flavor : transferFlavors) {
            if (flavor == null || !flavor.equals(DataFlavor.javaFileListFlavor) && !flavor.equals(LinuxDragAndDropSupport.uriListFlavor) && !flavor.equals(LinuxDragAndDropSupport.gnomeFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static List<File> getFileList(@NotNull Transferable transferable) {
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                return ContainerUtil.filter((Collection)fileList, file2 -> !Strings.isEmptyOrSpaces((CharSequence)file2.getPath()));
            }
            return LinuxDragAndDropSupport.getFiles(transferable);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    public static List<File> getFileListFromAttachedObject(Object attached) {
        List<File> result2 = attached instanceof TransferableWrapper ? ((TransferableWrapper)attached).asFileList() : (attached instanceof DnDNativeTarget.EventInfo ? FileCopyPasteUtil.getFileList(((DnDNativeTarget.EventInfo)attached).getTransferable()) : null);
        return result2 == null ? Collections.emptyList() : result2;
    }

    @NotNull
    public static List<VirtualFile> getVirtualFileListFromAttachedObject(Object attached) {
        List<VirtualFile> result2;
        List<File> fileList = FileCopyPasteUtil.getFileListFromAttachedObject(attached);
        if (fileList.isEmpty()) {
            result2 = Collections.emptyList();
        } else {
            result2 = new ArrayList<VirtualFile>(fileList.size());
            for (File file2 : fileList) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file2, (boolean)true);
                if (virtualFile == null) continue;
                result2.add(virtualFile);
                virtualFile.getFileType();
            }
        }
        return result2;
    }
}

